/*
 * Decompiled with CFR 0.152.
 */
package jp.ricksoft.plugins.alfresco.ao.service;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.confluence.api.service.accessmode.AccessModeService;
import com.atlassian.confluence.api.service.exceptions.ReadOnlyException;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.util.i18n.I18NBeanFactory;
import com.atlassian.sal.api.rdbms.ConnectionCallback;
import com.atlassian.sal.api.rdbms.TransactionalExecutor;
import com.atlassian.sal.api.rdbms.TransactionalExecutorFactory;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import jp.ricksoft.plugins.alfresco.ao.entity.DocumentLinkEntity;
import jp.ricksoft.plugins.alfresco.ao.service.DocumentLinkService;
import jp.ricksoft.plugins.alfresco.ao.service.DocumentLinkStreamCallback;
import jp.ricksoft.plugins.alfresco.ao.service.jdbc.Dialect;
import jp.ricksoft.plugins.alfresco.ao.service.jdbc.DialectFactory;
import net.java.ao.DBParam;
import net.java.ao.EntityStreamCallback;
import net.java.ao.Query;
import net.java.ao.RawEntity;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocumentLinkServiceImpl
implements DocumentLinkService {
    private static final Logger LOGGER = LoggerFactory.getLogger(DocumentLinkServiceImpl.class);
    private final ActiveObjects ao;
    private final TransactionalExecutorFactory transactionalExecutorFactory;
    private final AccessModeService accessModeService;
    private final I18NBeanFactory i18NBeanFactory;

    public DocumentLinkServiceImpl(ActiveObjects ao, TransactionalExecutorFactory transactionalExecutorFactory, AccessModeService accessModeService, I18NBeanFactory i18NBeanFactory) {
        this.ao = ao;
        this.transactionalExecutorFactory = transactionalExecutorFactory;
        this.accessModeService = accessModeService;
        this.i18NBeanFactory = i18NBeanFactory;
    }

    @Override
    public void save(AbstractPage page, List<String> objectIds, ConfluenceUser user) {
        if (this.accessModeService.isReadOnlyAccessModeEnabled()) {
            throw new ReadOnlyException(this.i18NBeanFactory.getI18NBean().getText("read.only.mode.default.banner.message"));
        }
        Date currentDate = new Date(System.currentTimeMillis());
        Long spaceId = page.getSpace().getId();
        Long pageId = page.getId();
        for (String objectId : this.convertObjectId(objectIds)) {
            DocumentLinkEntity[] entities = this.find(page, objectId);
            if (entities != null && entities.length > 0) continue;
            this.ao.create(DocumentLinkEntity.class, new DBParam[]{new DBParam("SPACE_ID", (Object)spaceId), new DBParam("PAGE_ID", (Object)pageId), new DBParam("AUTHOR_KEY", (Object)user.getName()), new DBParam("CREATED", (Object)currentDate), new DBParam("OBJECT_ID", (Object)objectId)});
        }
    }

    @Override
    public void save(List<AbstractPage> pages, String objectId, ConfluenceUser user) {
        if (this.accessModeService.isReadOnlyAccessModeEnabled()) {
            throw new ReadOnlyException(this.i18NBeanFactory.getI18NBean().getText("read.only.mode.default.banner.message"));
        }
        Date currentDate = new Date(System.currentTimeMillis());
        for (AbstractPage page : pages) {
            Long spaceId = page.getSpace().getId();
            Long pageId = page.getId();
            DocumentLinkEntity[] entities = this.find(page, objectId);
            if (entities != null && entities.length > 0) continue;
            this.ao.create(DocumentLinkEntity.class, new DBParam[]{new DBParam("SPACE_ID", (Object)spaceId), new DBParam("PAGE_ID", (Object)pageId), new DBParam("AUTHOR_KEY", (Object)user.getName()), new DBParam("CREATED", (Object)currentDate), new DBParam("OBJECT_ID", (Object)objectId)});
        }
    }

    @Override
    public void delete(AbstractPage page) {
        if (this.accessModeService.isReadOnlyAccessModeEnabled()) {
            throw new ReadOnlyException(this.i18NBeanFactory.getI18NBean().getText("read.only.mode.default.banner.message"));
        }
        this.ao.delete((RawEntity[])this.find(page));
    }

    @Override
    public void delete(AbstractPage page, List<String> objectIds) {
        if (this.accessModeService.isReadOnlyAccessModeEnabled()) {
            throw new ReadOnlyException(this.i18NBeanFactory.getI18NBean().getText("read.only.mode.default.banner.message"));
        }
        this.ao.delete((RawEntity[])this.find(page, objectIds));
    }

    @Override
    public void delete(List<AbstractPage> pages, String objectId) {
        if (this.accessModeService.isReadOnlyAccessModeEnabled()) {
            throw new ReadOnlyException(this.i18NBeanFactory.getI18NBean().getText("read.only.mode.default.banner.message"));
        }
        this.ao.delete((RawEntity[])this.find(pages, objectId));
    }

    @Override
    public int countObjectId(final AbstractPage page) {
        TransactionalExecutor executor = this.transactionalExecutorFactory.createReadOnly();
        final String schemaName = this.getSchemaName(executor);
        return (Integer)executor.execute((ConnectionCallback)new ConnectionCallback<Integer>(){

            public Integer execute(Connection connection) {
                ArrayList results = new ArrayList();
                PreparedStatement preparedStatement = null;
                ResultSet resultSet = null;
                try {
                    Dialect dialect = DialectFactory.getDialect(connection);
                    String sql = " SELECT  count(distinct " + dialect.quote("OBJECT_ID") + ")  FROM " + DocumentLinkServiceImpl.this.appendSchemaToTable(dialect.quote(schemaName), dialect.quote("AO_B64EA1_DOCUMENT_LINK_ENTITY")) + " WHERE " + dialect.quote("PAGE_ID") + " = ? ";
                    LOGGER.debug("countObjectId(issue) sql => " + sql);
                    preparedStatement = connection.prepareStatement(sql);
                    preparedStatement.setLong(1, page.getId());
                    resultSet = preparedStatement.executeQuery();
                    resultSet.next();
                    Integer n = resultSet.getInt(1);
                    DocumentLinkServiceImpl.this.closeQuietly(preparedStatement, resultSet);
                    return n;
                }
                catch (SQLException e) {
                    try {
                        throw new RuntimeException(e);
                    }
                    catch (Throwable throwable) {
                        DocumentLinkServiceImpl.this.closeQuietly(preparedStatement, resultSet);
                        throw throwable;
                    }
                }
            }
        });
    }

    @Override
    public int countObjectId(final Space space) {
        TransactionalExecutor executor = this.transactionalExecutorFactory.createExecutor();
        final String schemaName = this.getSchemaName(executor);
        return (Integer)executor.execute((ConnectionCallback)new ConnectionCallback<Integer>(){

            public Integer execute(Connection connection) {
                ArrayList results = new ArrayList();
                PreparedStatement preparedStatement = null;
                ResultSet resultSet = null;
                try {
                    Dialect dialect = DialectFactory.getDialect(connection);
                    String sql = " SELECT  count(distinct " + dialect.quote("OBJECT_ID") + ")  FROM " + DocumentLinkServiceImpl.this.appendSchemaToTable(dialect.quote(schemaName), dialect.quote("AO_B64EA1_DOCUMENT_LINK_ENTITY")) + " WHERE " + dialect.quote("SPACE_ID") + " = ? ";
                    LOGGER.debug("countObjectId(project) sql => " + sql);
                    preparedStatement = connection.prepareStatement(sql);
                    preparedStatement.setLong(1, space.getId());
                    resultSet = preparedStatement.executeQuery();
                    resultSet.next();
                    Integer n = resultSet.getInt(1);
                    DocumentLinkServiceImpl.this.closeQuietly(preparedStatement, resultSet);
                    return n;
                }
                catch (SQLException e) {
                    try {
                        throw new RuntimeException(e);
                    }
                    catch (Throwable throwable) {
                        DocumentLinkServiceImpl.this.closeQuietly(preparedStatement, resultSet);
                        throw throwable;
                    }
                }
            }
        });
    }

    @Override
    public List<String> findObjectId(final AbstractPage page, final int offset, final int limit) {
        TransactionalExecutor executor = this.transactionalExecutorFactory.createExecutor();
        final String schemaName = this.getSchemaName(executor);
        return (List)executor.execute((ConnectionCallback)new ConnectionCallback<List<String>>(){

            public List<String> execute(Connection connection) {
                ArrayList<String> results = new ArrayList<String>();
                PreparedStatement preparedStatement = null;
                ResultSet resultSet = null;
                try {
                    Dialect dialect = DialectFactory.getDialect(connection);
                    String sql = dialect.limit(" SELECT " + dialect.quote("OBJECT_ID") + " FROM " + DocumentLinkServiceImpl.this.appendSchemaToTable(dialect.quote(schemaName), dialect.quote("AO_B64EA1_DOCUMENT_LINK_ENTITY")) + " WHERE " + dialect.quote("PAGE_ID") + " = ?  GROUP BY " + dialect.quote("OBJECT_ID") + " ORDER BY max(" + dialect.quote("CREATED") + ") DESC", limit, offset);
                    LOGGER.debug("findObjectId(issue) sql => " + sql);
                    preparedStatement = connection.prepareStatement(sql);
                    preparedStatement.setLong(1, page.getId());
                    resultSet = preparedStatement.executeQuery();
                    while (resultSet.next()) {
                        String objectId = resultSet.getString("OBJECT_ID");
                        if (StringUtils.isEmpty((CharSequence)objectId)) continue;
                        results.add(objectId);
                    }
                    DocumentLinkServiceImpl.this.closeQuietly(preparedStatement, resultSet);
                }
                catch (SQLException e) {
                    try {
                        throw new RuntimeException(e);
                    }
                    catch (Throwable throwable) {
                        DocumentLinkServiceImpl.this.closeQuietly(preparedStatement, resultSet);
                        throw throwable;
                    }
                }
                return results;
            }
        });
    }

    @Override
    public List<String> findObjectId(final Space space, final int offset, final int limit) {
        TransactionalExecutor executor = this.transactionalExecutorFactory.createExecutor();
        final String schemaName = this.getSchemaName(executor);
        return (List)executor.execute((ConnectionCallback)new ConnectionCallback<List<String>>(){

            public List<String> execute(Connection connection) {
                ArrayList<String> results = new ArrayList<String>();
                PreparedStatement preparedStatement = null;
                ResultSet resultSet = null;
                try {
                    Dialect dialect = DialectFactory.getDialect(connection);
                    String sql = dialect.limit(" SELECT " + dialect.quote("OBJECT_ID") + " FROM " + DocumentLinkServiceImpl.this.appendSchemaToTable(dialect.quote(schemaName), dialect.quote("AO_B64EA1_DOCUMENT_LINK_ENTITY")) + " WHERE " + dialect.quote("SPACE_ID") + " = ?  GROUP BY " + dialect.quote("OBJECT_ID") + " ORDER BY max(" + dialect.quote("CREATED") + ") DESC", limit, offset);
                    LOGGER.debug("findObjectId(project) sql => " + sql);
                    preparedStatement = connection.prepareStatement(sql);
                    preparedStatement.setLong(1, space.getId());
                    resultSet = preparedStatement.executeQuery();
                    while (resultSet.next()) {
                        String objectId = resultSet.getString("OBJECT_ID");
                        if (StringUtils.isEmpty((CharSequence)objectId)) continue;
                        results.add(objectId);
                    }
                    DocumentLinkServiceImpl.this.closeQuietly(preparedStatement, resultSet);
                }
                catch (SQLException e) {
                    try {
                        throw new RuntimeException(e);
                    }
                    catch (Throwable throwable) {
                        DocumentLinkServiceImpl.this.closeQuietly(preparedStatement, resultSet);
                        throw throwable;
                    }
                }
                return results;
            }
        });
    }

    @Override
    public List<String> findObjectId(Long pageId) {
        DocumentLinkEntity[] entities = (DocumentLinkEntity[])this.ao.find(DocumentLinkEntity.class, Query.select().where("PAGE_ID = ?", new Object[]{pageId}));
        return Lists.newArrayList(Iterables.transform(Arrays.asList(entities), new Function<DocumentLinkEntity, String>(){

            @Override
            public String apply(DocumentLinkEntity input) {
                return input.getObjectId();
            }
        }));
    }

    @Override
    public DocumentLinkEntity[] find(AbstractPage page) {
        return (DocumentLinkEntity[])this.ao.find(DocumentLinkEntity.class, Query.select().where("PAGE_ID = ?", new Object[]{page.getId()}));
    }

    @Override
    public DocumentLinkEntity[] find(AbstractPage page, List<String> objectIds) {
        String placeholder = Joiner.on(", ").join(Iterables.transform(objectIds, Functions.constant("?")));
        ArrayList<Object> params = Lists.newArrayList();
        params.add(page.getId());
        params.addAll(Lists.newArrayList(this.convertObjectId(objectIds)));
        return (DocumentLinkEntity[])this.ao.find(DocumentLinkEntity.class, Query.select().where("PAGE_ID = ? AND OBJECT_ID IN (" + placeholder + ")", Iterables.toArray(params, Object.class)));
    }

    @Override
    public DocumentLinkEntity[] find(AbstractPage page, String objectId) {
        return (DocumentLinkEntity[])this.ao.find(DocumentLinkEntity.class, Query.select().where("OBJECT_ID = ? AND PAGE_ID = ?", new Object[]{objectId, page.getId()}));
    }

    @Override
    public DocumentLinkEntity[] find(List<AbstractPage> pages, String objectId) {
        ArrayList<Long> pageIds = new ArrayList<Long>();
        for (AbstractPage page : pages) {
            pageIds.add(page.getId());
        }
        String placeholder = Joiner.on(", ").join(Iterables.transform(pageIds, Functions.constant("?")));
        ArrayList<String> params = Lists.newArrayList();
        params.add(objectId);
        params.addAll(Lists.newArrayList(pageIds));
        return (DocumentLinkEntity[])this.ao.find(DocumentLinkEntity.class, Query.select().where("OBJECT_ID = ? AND PAGE_ID IN (" + placeholder + ")", Iterables.toArray(params, Object.class)));
    }

    @Override
    public void streamEntityByObjectId(List<String> objectIds, final DocumentLinkStreamCallback callback) {
        if (objectIds.isEmpty()) {
            return;
        }
        String placeholder = Joiner.on(", ").join(Iterables.transform(objectIds, Functions.constant("?")));
        ArrayList<String> params = Lists.newArrayList();
        params.addAll(Lists.newArrayList(this.convertObjectId(objectIds)));
        this.ao.stream(DocumentLinkEntity.class, Query.select((String)"ID, SPACE_ID, PAGE_ID, OBJECT_ID, AUTHOR_KEY, CREATED").where("OBJECT_ID IN (" + placeholder + ")", Iterables.toArray(params, Object.class)).order("CREATED DESC"), (EntityStreamCallback)new EntityStreamCallback<DocumentLinkEntity, Integer>(){

            public void onRowRead(DocumentLinkEntity t) {
                callback.valueRead(t);
            }
        });
    }

    @Override
    public void streamPageId(final DocumentLinkStreamCallback callback) {
        this.ao.stream(DocumentLinkEntity.class, Query.select((String)"ID, PAGE_ID, OBJECT_ID"), (EntityStreamCallback)new EntityStreamCallback<DocumentLinkEntity, Integer>(){

            public void onRowRead(DocumentLinkEntity t) {
                callback.valueRead(t);
            }
        });
    }

    @Override
    public void streamPageIdByObjectId(List<String> objectIds, final DocumentLinkStreamCallback callback) {
        if (objectIds.isEmpty()) {
            return;
        }
        String placeholder = Joiner.on(", ").join(Iterables.transform(objectIds, Functions.constant("?")));
        ArrayList<String> params = Lists.newArrayList();
        params.addAll(Lists.newArrayList(this.convertObjectId(objectIds)));
        this.ao.stream(DocumentLinkEntity.class, Query.select((String)"ID, PAGE_ID, OBJECT_ID").where("OBJECT_ID IN (" + placeholder + ")", Iterables.toArray(params, Object.class)), (EntityStreamCallback)new EntityStreamCallback<DocumentLinkEntity, Integer>(){

            public void onRowRead(DocumentLinkEntity t) {
                callback.valueRead(t);
            }
        });
    }

    @Override
    public Iterable<String> convertObjectId(Iterable<String> objectId) {
        return Iterables.transform(objectId, new Function<String, String>(){

            @Override
            public String apply(String input) {
                return DocumentLinkServiceImpl.this.convertObjectId(input);
            }
        });
    }

    @Override
    public String convertObjectId(String objectId) {
        return objectId.contains(";") ? objectId.substring(0, objectId.indexOf(59)) : objectId;
    }

    @Override
    public DocumentLinkEntity[] findByObjectId(String objectId) {
        return (DocumentLinkEntity[])this.ao.find(DocumentLinkEntity.class, Query.select().where("OBJECT_ID = ?", new Object[]{objectId}));
    }

    String appendSchemaToTable(String schemaName, String tableName) {
        if (StringUtils.isNotBlank((CharSequence)schemaName) && !tableName.startsWith(schemaName)) {
            return schemaName + "." + tableName;
        }
        return tableName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeQuietly(Statement stmt, ResultSet rs) {
        try {
            if (rs != null) {
                rs.close();
            }
        }
        catch (SQLException sQLException) {
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException sQLException) {}
        }
    }

    private String getSchemaName(TransactionalExecutor executor) {
        try {
            Class<?> optionClass;
            Method method = null;
            try {
                optionClass = Class.forName("com.atlassian.fugue.Option");
                method = TransactionalExecutor.class.getMethod("getSchemaName", optionClass);
            }
            catch (Exception e) {
                optionClass = Class.forName("io.atlassian.fugue.Option");
                TransactionalExecutor.class.getMethod("getSchemaName", optionClass);
            }
            Object ret = method.invoke((Object)executor, new Object[0]);
            Method getOrElseMethod = optionClass.getMethod("getOrElse", Object.class);
            return (String)getOrElseMethod.invoke(ret, "");
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }
}

