/*
 * Decompiled with CFR 0.152.
 */
package jp.ricksoft.plugins.alfresco.admin;

import com.atlassian.annotations.security.XsrfProtectionExcluded;
import com.atlassian.xwork.HttpMethod;
import com.atlassian.xwork.ParameterSafe;
import com.atlassian.xwork.PermittedMethods;
import com.atlassian.xwork.RequireSecurityToken;
import jp.ricksoft.plugins.alfresco.admin.MappingFolderAction;
import jp.ricksoft.plugins.alfresco.ao.entity.MappingFolder;
import jp.ricksoft.plugins.alfresco.ao.entity.MappingFolderType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MappingFolderRemoveAction
extends MappingFolderAction {
    private static final long serialVersionUID = 2169745777527374397L;
    private static final Logger LOGGER = LoggerFactory.getLogger(MappingFolderRemoveAction.class);
    private Integer folderId;
    private String name;
    private String type = MappingFolderType.PUBLIC.name();
    private String cmisFolderId;
    private Long[] spaceIds;

    @Override
    @XsrfProtectionExcluded
    @PermittedMethods(value={HttpMethod.GET})
    @RequireSecurityToken(value=true)
    public String execute() {
        if (this.isInvalidLicense()) {
            return this.getInvalidLicenseRedirect();
        }
        this.doValidate();
        if (this.hasErrors()) {
            return "error";
        }
        MappingFolder folder = this.mappingFolderService.getFolder(this.folderId);
        this.setName(folder.getName());
        this.setType(folder.getType());
        this.setCmisFolderId(folder.getPath().getCmisFolderId());
        this.setSpaceIds(folder.getSpaceIds());
        return "success";
    }

    @RequireSecurityToken(value=true)
    public String doSave() {
        LOGGER.debug("doSave() start");
        if (this.isInvalidLicense()) {
            return this.getInvalidLicenseRedirect();
        }
        this.doValidate();
        if (this.hasErrors()) {
            return "error";
        }
        this.mappingFolderService.deleteFolder(this.folderId);
        return "success";
    }

    public Integer getFolderId() {
        return this.folderId;
    }

    @ParameterSafe
    public void setFolderId(Integer folderId) {
        this.folderId = folderId;
    }

    public String getName() {
        return this.name;
    }

    @ParameterSafe
    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return this.type;
    }

    @ParameterSafe
    public void setType(String type) {
        this.type = type;
    }

    public String getCmisFolderId() {
        return this.cmisFolderId;
    }

    @ParameterSafe
    public void setCmisFolderId(String cmisFolderId) {
        this.cmisFolderId = cmisFolderId;
    }

    public Long[] getSpaceIds() {
        return this.spaceIds;
    }

    @ParameterSafe
    public void setSpaceIds(Long[] spaceIds) {
        this.spaceIds = spaceIds;
    }

    void doValidate() {
        if (this.folderId == null) {
            this.addActionError(this.getText("alfresco.for.confluence.admin.mapping-folder.folderId.error.empty"));
        }
        if (this.folderId != null && this.mappingFolderService.getFolder(this.folderId) == null) {
            this.addActionError(this.getText("alfresco.for.confluence.admin.mapping-folder.folderId.error.removed", this.folderId.toString()));
        }
    }

    public String[] getSelectableTypes() {
        return MappingFolderType.getNames();
    }

    @Override
    public String getSelectableTypeName(String name) {
        return this.getText("alfresco.for.confluence.admin.mapping-folder.type." + name.toLowerCase());
    }
}

