/*
 * Decompiled with CFR 0.152.
 */
package jp.ricksoft.plugins.alfresco.admin;

import com.atlassian.annotations.security.XsrfProtectionExcluded;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.xwork.HttpMethod;
import com.atlassian.xwork.PermittedMethods;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import jp.ricksoft.plugins.alfresco.admin.AlfrescoBaseAction;
import jp.ricksoft.plugins.alfresco.ao.entity.MappingFolder;
import jp.ricksoft.plugins.alfresco.ao.entity.MappingFolderType;
import jp.ricksoft.plugins.alfresco.ao.service.MappingFolderService;
import jp.ricksoft.plugins.alfresco.auth.InvalidTokenException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MappingFolderAction
extends AlfrescoBaseAction {
    private static final long serialVersionUID = -1506738031835644741L;
    private static final Logger LOGGER = LoggerFactory.getLogger(MappingFolderAction.class);
    protected MappingFolderService mappingFolderService;
    protected SpaceManager spaceManager;
    private List<MappingFolder> publicFolders;
    private List<MappingFolder> privateFolders;
    private List<String> messages = new ArrayList<String>();

    public void setMappingFolderService(MappingFolderService mappingFolderService) {
        this.mappingFolderService = mappingFolderService;
    }

    public void setSpaceManager(SpaceManager spaceManager) {
        this.spaceManager = spaceManager;
    }

    @XsrfProtectionExcluded
    @PermittedMethods(value={HttpMethod.GET})
    public String execute() {
        if (this.isInvalidLicense()) {
            return this.getInvalidLicenseRedirect();
        }
        try {
            ConfluenceUser user = this.getAuthenticatedUser();
            if (this.isOverMaximumLoginAttemptAllowed()) {
                LOGGER.warn("Cmis Maximum Login Attempt Allowed Over Error.");
                this.addActionError(this.getText("alfresco.for.confluence.admin.error.overMaximumLoginAttemptAllowed"));
                return "error";
            }
            Comparator<MappingFolder> folderComparator = new Comparator<MappingFolder>(){

                @Override
                public int compare(MappingFolder o1, MappingFolder o2) {
                    return o1.getName().compareTo(o2.getName());
                }
            };
            List<MappingFolder> publicFolders = this.mappingFolderService.getFolders(MappingFolderType.PUBLIC);
            Collections.sort(publicFolders, folderComparator);
            this.setPublicFolders(publicFolders);
            List<MappingFolder> privateFolders = this.mappingFolderService.getFolders(MappingFolderType.PRIVATE);
            Collections.sort(privateFolders, folderComparator);
            this.setPrivateFolders(privateFolders);
        }
        catch (InvalidTokenException e) {
            LOGGER.warn("Cmis Invalid Token Error.", (Throwable)e);
            this.addActionError(this.getText("alfresco.for.confluence.admin.error.token"));
        }
        catch (Exception e) {
            LOGGER.warn("Cmis Invalid Token Error.", (Throwable)e);
            this.addActionError(this.getText("alfresco.for.confluence.admin.error.unexpected"));
        }
        if (this.hasErrors()) {
            return "error";
        }
        return "success";
    }

    public List<MappingFolder> getPublicFolders() {
        return this.publicFolders;
    }

    public void setPublicFolders(List<MappingFolder> publicFolders) {
        this.publicFolders = publicFolders;
    }

    public List<MappingFolder> getPrivateFolders() {
        return this.privateFolders;
    }

    public void setPrivateFolders(List<MappingFolder> privateFolders) {
        this.privateFolders = privateFolders;
    }

    public List<String> getMessages() {
        return this.messages;
    }

    public void addMessage(String message) {
        this.messages.add(message);
    }

    public String getSpaceName(long spaceId) {
        Space space = this.spaceManager.getSpace(spaceId);
        if (space != null) {
            return space.getName();
        }
        return "";
    }

    public String getSpaceKey(long spaceId) {
        Space space = this.spaceManager.getSpace(spaceId);
        if (space != null) {
            return space.getKey();
        }
        return "";
    }

    public String[] getSelectableType() {
        return MappingFolderType.getNames();
    }

    public String getSelectableTypeName(String name) {
        return this.getText("alfresco.for.confluence.admin.mapping-folder.type." + name.toLowerCase());
    }
}

