/*
 * Decompiled with CFR 0.152.
 */
package jp.ricksoft.plugins.alfresco.admin;

import com.atlassian.annotations.security.XsrfProtectionExcluded;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.xwork.HttpMethod;
import com.atlassian.xwork.PermittedMethods;
import jp.ricksoft.plugins.alfresco.admin.AlfrescoBaseAction;
import jp.ricksoft.plugins.alfresco.auth.InvalidTokenException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeaturePermissionAction
extends AlfrescoBaseAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(FeaturePermissionAction.class);

    @XsrfProtectionExcluded
    @PermittedMethods(value={HttpMethod.GET})
    public String execute() {
        if (this.isInvalidLicense()) {
            return this.getInvalidLicenseRedirect();
        }
        try {
            ConfluenceUser user = this.getAuthenticatedUser();
            if (this.isOverMaximumLoginAttemptAllowed()) {
                LOGGER.warn("Cmis Maximum Login Attempt Allowed Over Error.");
                this.addActionError(this.getText("alfresco.for.jira.admin.error.overMaximumLoginAttemptAllowed"));
                return "error";
            }
        }
        catch (InvalidTokenException e) {
            LOGGER.warn("Cmis Invalid Token Error.", (Throwable)e);
            this.addActionError(this.getText("alfresco.for.jira.admin.error.token"));
        }
        catch (Exception e) {
            LOGGER.warn("Cmis Invalid Token Error.", (Throwable)e);
            this.addActionError(this.getText("alfresco.for.jira.admin.error.unexpected"));
        }
        return "success";
    }
}

