/*
 * Decompiled with CFR 0.152.
 */
package jp.ricksoft.plugins.alfresco.admin;

import com.atlassian.annotations.security.XsrfProtectionExcluded;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.xwork.HttpMethod;
import com.atlassian.xwork.ParameterSafe;
import com.atlassian.xwork.PermittedMethods;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import jp.ricksoft.plugins.alfresco.admin.AlfrescoBaseAction;
import jp.ricksoft.plugins.alfresco.ao.entity.CredentialEntity;
import jp.ricksoft.plugins.alfresco.ao.service.CredentialTokenProvider;
import jp.ricksoft.plugins.alfresco.auth.InvalidTokenException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CredentialAction
extends AlfrescoBaseAction {
    private static final long serialVersionUID = -1506738031835644741L;
    private static final Logger LOGGER = LoggerFactory.getLogger(CredentialAction.class);
    protected String alfrescoDisplayUrl;
    protected String alfrescoApplicationUrl;
    protected String shareDisplayUrl;
    protected String authType;
    protected String accessType;
    protected String username;
    protected String password;
    protected Integer maximumLoginAttemptAllowed;
    protected String lastFailedLogin;
    protected Integer currentLoginFailedCount;
    protected boolean limitMaximumLoginAttemptAllowed;
    protected List<String> messages = new ArrayList<String>();

    @XsrfProtectionExcluded
    @PermittedMethods(value={HttpMethod.GET})
    public String execute() throws InvalidTokenException {
        ConfluenceUser user;
        CredentialTokenProvider credentialTokenProvider;
        if (this.isInvalidLicense()) {
            return this.getInvalidLicenseRedirect();
        }
        CredentialEntity credential = this.credentialService.find();
        if (credential != null) {
            this.setAlfrescoDisplayUrl(credential.getAlfrescoDisplayUrl());
            this.setAlfrescoApplicationUrl(credential.getAlfrescoApplicationUrl());
            this.setShareDisplayUrl(credential.getShareDisplayUrl());
            this.setAuthType(credential.getAuthType());
            this.setAccessType(credential.getAccessType());
            this.setUsername(credential.getUsername());
            this.setMaximumLoginAttemptAllowed(credential.getMaximumLoginAttemptAllowed());
        }
        if ((credentialTokenProvider = this.credentialService.generateTokenProvider(user = this.getAuthenticatedUser(), true)) != null) {
            this.setLastFailedLogin(credentialTokenProvider.getLastFailedLogin());
            this.setCurrentLoginFailedCount(credentialTokenProvider.getCurrentLoginFailedCount());
            this.setLimitMaximumLoginAttemptAllowed(credentialTokenProvider.isLimitMaximumLoginAttemptAllowed());
        }
        return "success";
    }

    public String getAlfrescoDisplayUrl() {
        return this.alfrescoDisplayUrl;
    }

    @ParameterSafe
    public void setAlfrescoDisplayUrl(String alfrescoDisplayUrl) {
        this.alfrescoDisplayUrl = alfrescoDisplayUrl;
    }

    public String getAlfrescoApplicationUrl() {
        return this.alfrescoApplicationUrl;
    }

    @ParameterSafe
    public void setAlfrescoApplicationUrl(String alfrescoApplicationUrl) {
        this.alfrescoApplicationUrl = alfrescoApplicationUrl;
    }

    @ParameterSafe
    public void setShareDisplayUrl(String shareDisplayUrl) {
        this.shareDisplayUrl = shareDisplayUrl;
    }

    public String getShareDisplayUrl() {
        return this.shareDisplayUrl;
    }

    public String getAuthType() {
        return this.authType;
    }

    @ParameterSafe
    public void setAuthType(String authType) {
        this.authType = authType;
    }

    public String getAccessType() {
        return this.accessType;
    }

    @ParameterSafe
    public void setAccessType(String accessType) {
        this.accessType = accessType;
    }

    public String getUsername() {
        return this.username;
    }

    @ParameterSafe
    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    @ParameterSafe
    public void setPassword(String password) {
        this.password = password;
    }

    public Integer getMaximumLoginAttemptAllowed() {
        return this.maximumLoginAttemptAllowed;
    }

    @ParameterSafe
    public void setMaximumLoginAttemptAllowed(Integer maximumLoginAttemptAllowed) {
        this.maximumLoginAttemptAllowed = maximumLoginAttemptAllowed;
    }

    public String getLastFailedLogin() {
        return this.lastFailedLogin;
    }

    @ParameterSafe
    public void setLastFailedLogin(String lastFailedLogin) {
        this.lastFailedLogin = lastFailedLogin;
    }

    public Integer getCurrentLoginFailedCount() {
        return this.currentLoginFailedCount;
    }

    @ParameterSafe
    public void setCurrentLoginFailedCount(Integer currentLoginFailedCount) {
        this.currentLoginFailedCount = currentLoginFailedCount;
    }

    public boolean isLimitMaximumLoginAttemptAllowed() {
        return this.limitMaximumLoginAttemptAllowed;
    }

    @ParameterSafe
    public void setLimitMaximumLoginAttemptAllowed(boolean limitMaximumLoginAttemptAllowed) {
        this.limitMaximumLoginAttemptAllowed = limitMaximumLoginAttemptAllowed;
    }

    public List<String> getMessages() {
        return this.messages;
    }

    public void addMessage(String message) {
        this.messages.add(message);
    }

    public String getAuthTypeLabel(String authType) {
        Map<String, String> selectable = this.getSelectableAuthType();
        if (StringUtils.isEmpty((CharSequence)authType)) {
            return selectable.get("Basic");
        }
        if (selectable.containsKey(authType)) {
            return selectable.get(authType);
        }
        return null;
    }

    public Map<String, String> getSelectableAuthType() {
        TreeMap<String, String> selectable = new TreeMap<String, String>();
        selectable.put("Basic", this.getText("alfresco.for.confluence.admin.authType.basic.label"));
        selectable.put("WSSE", this.getText("alfresco.for.confluence.admin.authType.wsse.label"));
        return selectable;
    }

    public String getAccessTypeLabel(String accessType) {
        if (StringUtils.isEmpty((CharSequence)accessType)) {
            return null;
        }
        Map<String, String> selectable = this.getSelectableAccessType();
        if (selectable.containsKey(accessType)) {
            return selectable.get(accessType);
        }
        return null;
    }

    public Map<String, String> getSelectableAccessType() {
        LinkedHashMap<String, String> selectable = new LinkedHashMap<String, String>();
        selectable.put("WithAdminProfile", this.getText("alfresco.for.confluence.admin.accessType.with-admin-profile.label"));
        selectable.put("WithOwnProfile", this.getText("alfresco.for.confluence.admin.accessType.with-own-profile.label"));
        return selectable;
    }

    public boolean hasCredential() {
        return this.credentialService.find() != null;
    }
}

