/*
 * Decompiled with CFR 0.152.
 */
package jp.ricksoft.plugins.alfresco.admin;

import com.atlassian.annotations.security.XsrfProtectionExcluded;
import com.atlassian.xwork.HttpMethod;
import com.atlassian.xwork.ParameterSafe;
import com.atlassian.xwork.PermittedMethods;
import com.atlassian.xwork.RequireSecurityToken;
import jp.ricksoft.plugins.alfresco.admin.AlfrescoBaseAction;
import jp.ricksoft.plugins.alfresco.ao.service.GeneralConfigService;
import jp.ricksoft.plugins.alfresco.configuration.AdvancedConfigurationData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdvancedConfigurationAction
extends AlfrescoBaseAction {
    private static final long serialVersionUID = -2929696877962068713L;
    private static final Logger LOGGER = LoggerFactory.getLogger(AdvancedConfigurationAction.class);
    private GeneralConfigService generalConfigService;
    private Boolean enableAllFiles;
    private Boolean enableImEditing;
    private Boolean enableRecentlyModified;
    private Boolean enableRecentlyAdded;

    @XsrfProtectionExcluded
    @PermittedMethods(value={HttpMethod.GET})
    public String execute() {
        if (this.isInvalidLicense()) {
            return this.getInvalidLicenseRedirect();
        }
        AdvancedConfigurationData advancedConfig = this.generalConfigService.getAdvancedConfig();
        this.enableAllFiles = advancedConfig.enableAllFiles;
        this.enableImEditing = advancedConfig.enableImEditing;
        this.enableRecentlyModified = advancedConfig.enableRecentlyModified;
        this.enableRecentlyAdded = advancedConfig.enableRecentlyAdded;
        return "success";
    }

    @RequireSecurityToken(value=true)
    public String doSave() {
        LOGGER.debug("doExecute() start");
        if (this.isInvalidLicense()) {
            return this.getInvalidLicenseRedirect();
        }
        this.doValidate();
        if (this.hasErrors()) {
            return "error";
        }
        AdvancedConfigurationData advancedConfig = this.generalConfigService.getAdvancedConfig();
        advancedConfig.enableAllFiles = this.enableAllFiles != null ? this.enableAllFiles : false;
        advancedConfig.enableImEditing = this.enableImEditing != null ? this.enableImEditing : false;
        advancedConfig.enableRecentlyModified = this.enableRecentlyModified != null ? this.enableRecentlyModified : false;
        advancedConfig.enableRecentlyAdded = this.enableRecentlyAdded != null ? this.enableRecentlyAdded : false;
        this.generalConfigService.saveAdvancedConfig(advancedConfig);
        return "success";
    }

    void doValidate() {
    }

    public Boolean getEnableAllFiles() {
        return this.enableAllFiles;
    }

    @ParameterSafe
    public void setEnableAllFiles(Boolean enableAllFiles) {
        this.enableAllFiles = enableAllFiles;
    }

    public Boolean getEnableImEditing() {
        return this.enableImEditing;
    }

    @ParameterSafe
    public void setEnableImEditing(Boolean enableImEditing) {
        this.enableImEditing = enableImEditing;
    }

    public Boolean getEnableRecentlyModified() {
        return this.enableRecentlyModified;
    }

    @ParameterSafe
    public void setEnableRecentlyModified(Boolean enableRecentlyModified) {
        this.enableRecentlyModified = enableRecentlyModified;
    }

    public Boolean getEnableRecentlyAdded() {
        return this.enableRecentlyAdded;
    }

    @ParameterSafe
    public void setEnableRecentlyAdded(Boolean enableRecentlyAdded) {
        this.enableRecentlyAdded = enableRecentlyAdded;
    }

    public void setGeneralConfigService(GeneralConfigService generalConfigService) {
        this.generalConfigService = generalConfigService;
    }
}

