/*
 * Copyright 2016 Ricksoft Co., Ltd.
 * All rights reserved.
 */
define('cmis/search/init',
  ['jquery', 'cmis/cmisconfluence', 'cmis/cmislistview', 'cmis/confluence-listview-helper', 'cmis/confluence-error-handler', 'app/autocomplete-mapped-space'],
  function($, cmisConfluence, listview, listviewHelper, errorHandler, AutocompleteMappedSpace) {
  
  var CONFLUENCE_RESULT_PANEL_ID = "result-confluence-panel";
  var CONFLUENCE_LINK_ID = "cmis-link-confluence";
  var CMIS_RESULT_PANEL_ID = "result-cmis-panel";
  var CMIS_LINK_ID = "cmis-link-alfresco";
  var CMIS_RESULT_LISTVIEW_CLASS = "cmis-result-listview";
  var CMIS_RESULT_BLANKET = '.cmis-result-blanket';
  var VALID_ERROR_CLASS = '.cmis-validation-error';
  
  var confluenceResultPanel_;
  var confluenceLink_;
  var cmisResultPanel_;
  var cmisPagination_;
  var cmisLink_;
  var resultListview_;
  var blanket_;
  var cmisValidation_;
  var searchResults_;
  
  /**
   * 初期化
   */
  function init() {

    isEnabledSearch().done(function() {
      cmisConfluence.initCmisSession().done(function () {

        // ライセンスが無効な場合は表示しない
        if (cmisConfluence.isInvalidLicense()) {
          return;
        }

        // 画面表示を初期化
        setupView();

        AJS.$('#search-form').submit(function (event) {
          _.delay(function () {
            var selectedItem = $('#cmis-search-tab-container > .aui-navgroup li.aui-nav-selected');
            selectedItem.children('a').first().click();
          }, 1000);
        });


        $(document).ajaxComplete(function (event) {
          if (/dosearchsite.action/.test(event.currentTarget.URL)) {
            confluenceResultPanel_.find('.search-blanket').hide();
          }
        });

        // ハッシュに#cmisがあればcmisの検索結果を表示
        var hash = window.location.hash;
        if ('#cmis' == hash) {
          cmisLink_.click();
        }
      }).fail(function (jqXHR, textStatus) {

        AJS.$(CMIS_RESULT_BLANKET).addClass('hidden');
        // TODO
      });
    }).fail(function() {

    });

  }

  function isEnabledSearch() {

    var d = new AJS.$.Deferred;

    $.ajax({
      type : 'GET',
      dataType : 'json',
      contentType : 'application/json',
      url : contextPath + '/rest/alfresco/latest/picker/mappedspace',
      data: {
        "max-results": 1
      },
      cache : false
    }).done(function(data) {
      if (data.result.length > 0) {
        d.resolve();
      } else {
        d.reject();
      }
    }).fail(function() {
      d.reject();
    })

    return d.promise();
  }

  /**
   * 画面表示の初期化
   */
  function setupView() {
    var template = Cmis.Templates.Search.tabs();
    
    var $searchResultsHeader = $('#search-results-header');
    var $searchResultsPanel = $('#search-results-header + div.aui-page-panel-inner');
    $searchResultsHeader.after(template);
    
    $('#'+CONFLUENCE_RESULT_PANEL_ID).append($searchResultsPanel);
    
    AJS.tabs.setup();
    
    //
    confluenceResultPanel_ = $('#'+CONFLUENCE_RESULT_PANEL_ID);
    confluenceLink_ = $('#'+CONFLUENCE_LINK_ID);
    cmisResultPanel_ = $('#'+CMIS_RESULT_PANEL_ID);
    cmisLink_ = $('#'+CMIS_LINK_ID);
    cmisPagination_ = cmisResultPanel_.find('.cmis-pagination');
    blanket_ = cmisResultPanel_.find(CMIS_RESULT_BLANKET);
    cmisValidation_ = cmisResultPanel_.find(VALID_ERROR_CLASS);
    cmisValidation_.addClass('hidden');

    AutocompleteMappedSpace.bind();

    $("#cmis-field-space").on('select2-selected', function(e) {
      if (e.choice) {
        $(".cmis-filter-field-input-container > div.error").remove();
      }
    });
    
    confluenceLink_.click(function(event) {
      event.preventDefault();
      swapTabs($(this));
      
      //
      window.location.hash = '';
    });
    
    cmisLink_.click(function(event) {
      event.preventDefault();
      swapTabs($(this));

      var space = getSelectedSpace();
      
      if (cmisResultPanel_.attr('data-query') != $('#query-string').val()
          || (space && (cmisResultPanel_.attr('data-space-id') != space.entity.id))) {
        refreshPanel(0);
      }
      
      // 
      window.location.hash = '#cmis';
    });
    
    resultListview_ = listview.setup({
      cmis_session:cmisConfluence.getCmisSession(),
      el:$('.'+CMIS_RESULT_LISTVIEW_CLASS),
      helper:listviewHelper.create(),
      alfrescoUrl:cmisConfluence.getAlfrescoUrl(),
      explorerMode:false,
      autoReloadMode:true,
      dateformat:'YYYY/MM/DD',
      onRenderItem: onRenderItem
    });
  }
  
  function swapTabs(clickedLink) {
    var selectedItem = $('#cmis-search-tab-container > .aui-navgroup li.aui-nav-selected');
    var selectedPane = selectedItem.children('a').first().attr('href');

    var clickedItem = clickedLink.parent();
    var clickedPane = clickedLink.attr('href');

    // 
    selectedItem.removeClass('aui-nav-selected');
    clickedItem.addClass('aui-nav-selected');

    // 
    $(selectedPane).hide();
    $(clickedPane).show();
  }
  
  /**
   * 検索結果画面を更新する
   */
  function refreshPanel(pageNum) {
    blanket_.removeClass('hidden');
    cmisPagination_.addClass('hidden');
    cmisValidation_.addClass('hidden');
    cmisResultPanel_.find('.cmis-result-header').addClass('hidden'); // 検索ヘッダを隠す
    cmisResultPanel_.find('.'+CMIS_RESULT_LISTVIEW_CLASS).addClass('hidden'); // リストビューを隠す
    cmisResultPanel_.find(".aui-message").remove(); //
    
    var searchResultsPane = cmisResultPanel_.find('.cmis-results-wrapper');
    requestSearch(pageNum).done(function(data) {
      
      blanket_.addClass('hidden');

      if (!cmisConfluence.hasUserCredential()) {
        errorHandler.showError($(".aui-page-panel-content", cmisResultPanel_), {
          body: AJS.I18n.getText('alfresco.for.confluence.search.error.reload')
        });
        return ;
      }

      cmisPagination_.removeClass('hidden');


      // 検索結果を保存しておく
      searchResults_ = data;
      
      var query = $('#query-string').val();
      var space = getSelectedSpace();

      if (data.items.length <= 0) {
        // 検索結果なし
        var $noResults = cmisResultPanel_.find('.cmis-no-results');
        $noResults.empty().append(Cmis.Templates.Search.noResults({query:query}));
        $noResults.removeClass('hidden');
      } else {
        // 検索結果あり
        cmisResultPanel_.find('.cmis-no-results').addClass('hidden');
        cmisResultPanel_.find('.cmis-result-header').removeClass('hidden'); // 検索ヘッダ表示
      }
      
      // 検索文字列を保持しておく
      cmisResultPanel_.attr({
        'data-query': query,
        'data-space-id': space.entity.id
      });
      
      var objectIds = $.map(data.items, function(item) {
        return item.id;
      });
      
      // 結果のヘッダを表示
      var template = Cmis.Templates.Search.header({
                        totalSize:data.totalSize,
                        indexFrom:(data.pageNum*data.maxItemsPerPage)+1,
                        indexTo:Math.min((data.pageNum+1)*data.maxItemsPerPage, data.totalSize)
                     });
      cmisResultPanel_.find('.cmis-result-header').empty().append(template);

      // 権限を設定
      resultListview_.setPermissions($.extend(data.permissions, { document_link: false, document_all_unlink: false, document_own_unlink:false, document_createissue: false }));

      // リストを表示
      cmisConfluence.getDocumentByIds(objectIds).done(function(documents) {
        resultListview_.loadByArray(documents).done(function() {
          cmisResultPanel_.find('.'+CMIS_RESULT_LISTVIEW_CLASS).removeClass('hidden');
        });
      });
      
      // ページャ表示
      cmisPagination_.empty();
      if (data.totalSize > data.maxItemsPerPage) {
        var start = data.pageNum - 4 >= 0 ? data.pageNum - 4 : 0;
        var totalPage = data.totalSize/data.maxItemsPerPage;
        var end = totalPage >= data.pageNum + 5 ? data.pageNum + 5 : totalPage;
        var paginationTemplate = Cmis.Templates.Search.pagination({
                                    startPage: start,
                                    endPage: end,
                                    currentPage: data.pageNum,
                                    enablePrev: data.pageNum > 0,
                                    enableNext: data.pageNum+1 < totalPage
                                 });
        cmisPagination_.append(paginationTemplate);
        cmisPagination_.find('a').click(function(e) {
          e.preventDefault();
          refreshPanel($(this).attr('data-page'));
        });
      }
      
      
    }).fail(function(jqXHR, textStatus) {
      AJS.$(CMIS_RESULT_BLANKET).addClass('hidden');

      var errorObj;
      if (jqXHR && jqXHR.getResponseHeader("content-type") == "application/json" && jqXHR.responseText) {
        errorObj = jQuery.parseJSON( jqXHR.responseText );
      }

      if (errorObj && errorObj.cause) {
        if (errorObj.cause == "unregistered_credential_token") {
          errorHandler.showError($(".aui-page-panel-content", cmisResultPanel_), {
            body: AJS.I18n.getText('alfresco.for.confluence.ajax.error.token')
          });
        } else {
          errorHandler.showError($(".aui-page-panel-content", cmisResultPanel_), {
            body: errorObj.message
          });
        }
      }
    });
  }
  
  /**
   * 
   */
  function onRenderItem(el, doc, listview) {

    var docItem = $.grep(searchResults_.items, function(item) {
      return item.id == doc.id;
    });
    if (docItem.length <= 0) {
      return ;
    }
    
    var template = Cmis.Templates.Search.pages({pages:docItem[0].pages});
    el.find('.fileinfo > .liner').append(template);
  }

  function getSelectedSpace() {
    var $picker = $("#s2id_cmis-field-space");

    if ($picker.length > 0) {
      return $picker.select2("data");
    } else {
      return undefined;
    }
  }

  function addError($field, text) {
    $field.after("<div class='error'>" + text+ "</div>");
  }

  /**
   *
   * @returns {boolean}
   */
  function validation() {
    var space = getSelectedSpace();

    var hasError = false;

    $(".cmis-filter-field-input-container > div.error").remove();

    if (space) {
    } else {
      addError($("#cmis-field-space"), AJS.I18n.getText('alfresco.for.confluence.search.error.space.required'));
      hasError = true;
    }

    return !hasError;
  }


  /**
   * 
   */
  function requestSearch(pageNum) {

    if (!validation()) {
      return (new AJS.$.Deferred).reject();
    }

    var space = getSelectedSpace();

    var q = $('#query-string').val();
    return $.ajax({
      type : 'GET',
      dataType : 'json',
      contentType : 'application/json',
      url : contextPath + "/rest/alfresco/latest/search",
      data: {
        q: q,
        spaceKey: space.entity.spaceKey,
        p: pageNum,
      },
      cache : false
    });
  }
  
  return init;
});

AJS.toInit(function() {
  
  if (AJS.$('#search-results-header').length <= 0) {
    // 検索画面でなければ抜けてしまう
    return ;
  }
  
  require(['cmis/search/init'], function(init) {
    init();
  });
});
