/*
 * Copyright 2016 Ricksoft Co., Ltd.
 * All rights reserved.
 */

define('officeservice/officeservice', ['jquery', 'misc/util', 'cmis/cmisconfluence'], function($, util, cmisconflence) { 'use strict';


  function onActionEditOnlineAos(doc) {

    var d = new AJS.$.Deferred;

    doc.getParents().done(function(parents) {

      var parentFolders = $.grep(parents, function(n, i) {
        return n.isFolder()
      })

      if (parentFolders.length <= 0) {
        return d.reject({
          body: AJS.I18n.getText("alfresco.for.jira.ajax.error.server")
        })
      }

      var parentFolder = parentFolders[0];

      var aosUrl = getAosUrl(doc, parentFolder);
      if (aosUrl === undefined) {
        return d.reject({
          body: AJS.I18n.getText("alfresco.for.jira.ajax.error.server")
        })
      }

      innerOnActionEditOnlineAos(doc, aosUrl)
        .done(d.resolve)
        .fail(d.reject);
    });

    return d.promise();
  }

  function innerOnActionEditOnlineAos(doc, aosUrl) {

    var d = new AJS.$.Deferred;

    var protocolHandler = getProtocolHandler(doc);
    if (protocolHandler === undefined) {
      return d.reject({
        body: AJS.I18n.getText("alfresco.for.jira.officeservice.noSupportedFileExtension")
      });
    }

    // detect if we are on a supported operating system
    if(!isSupportedEnvironment()) {
      return d.reject({
        body: AJS.I18n.getText("alfresco.for.jira.onlineedit.noSupportedEnvironment")
      });
    }

    _aos_tryToLaunchOfficeByMsProtocolHandler(protocolHandler, aosUrl);

    return d.resolve();
  }

  function getProtocolHandler(doc) {

    var fileExtension = util.getFileExtension(doc.name);

    fileExtension = fileExtension != null ? fileExtension.toLowerCase() : fileExtension;
    var protocolHandler = getProtocolForFileExtension(fileExtension);

    return protocolHandler;
  }

  function isSupportedEnvironment() {

    var userAgent = navigator.userAgent.toLowerCase();
    var isMac = (userAgent.indexOf('mac') !== -1);
    var isWin = (userAgent.indexOf('win') !== -1);

    // detect if we are on a supported operating system
    return isWin || isMac;
  }

  function getAosUrl(doc, parentFolder) {

    console.log(parentFolder);

    var url = cmisconflence.getAlfrescoUrl() + "/aos" + parentFolder.path + "/" + doc.name;
    if (encodeURI(url).length <= 256) {
      return url;
    }

    var index = doc.nodeRef.lastIndexOf("/");
    if (index === -1) {
      return undefined;
    }

    var nodeId = doc.nodeRef.substring(index+1);

    return cmisconflence.getAlfrescoUrl() + "/aos/_aos_nodeid/" + nodeId + "/" + doc.name;
  }

  function canOnlineEdit(filename) {
    var fileExtension = util.getFileExtension(filename);

    fileExtension = fileExtension != null ? fileExtension.toLowerCase() : fileExtension;

    var protocolHandler = getProtocolForFileExtension(fileExtension);

    return protocolHandler !== undefined;
  }


  function _aos_tryToLaunchOfficeByMsProtocolHandler(protocolHandler, url) {
    location.href = protocolHandler + ':ofe%7Cu%7C' + url;
  }

  function getProtocolForFileExtension(fileExtension) {
    var msProtocolNames =
      {
        'doc'  : 'ms-word',
        'docx' : 'ms-word',
        'docm' : 'ms-word',
        'dot'  : 'ms-word',
        'dotx' : 'ms-word',
        'dotm' : 'ms-word',
        'xls'  : 'ms-excel',
        'xlsx' : 'ms-excel',
        'xlsb' : 'ms-excel',
        'xlsm' : 'ms-excel',
        'xlt'  : 'ms-excel',
        'xltx' : 'ms-excel',
        'xltm' : 'ms-excel',
        //'xlsm' : 'ms-excel',
        'ppt'  : 'ms-powerpoint',
        'pptx' : 'ms-powerpoint',
        'pot'  : 'ms-powerpoint',
        'potx' : 'ms-powerpoint',
        'potm' : 'ms-powerpoint',
        'pptm' : 'ms-powerpoint',
        //'potm' : 'ms-powerpoint',
        'pps'  : 'ms-powerpoint',
        'ppsx' : 'ms-powerpoint',
        'ppam' : 'ms-powerpoint',
        'ppsm' : 'ms-powerpoint',
        'sldx' : 'ms-powerpoint',
        'sldm' : 'ms-powerpoint',
      };
    return msProtocolNames[fileExtension];
  }

  return {
    onActionEditOnlineAos: onActionEditOnlineAos,
    canOnlineEdit: canOnlineEdit
  }

});
