/*
 * Copyright 2016 Ricksoft Co., Ltd.
 * All rights reserved.
 */
define('alfresco-macro/macroCommon',  ['jquery', 'cmis/cmisconfluence', 'attachments/attachment-permission'],  function($, cmisConfluence, attachmentPermission) {

  var permissions;

  /**
   * マクロ共通初期化処理
   */
  function init(errorPrefix) {

    var d = new AJS.$.Deferred;

    (function() {

      var d = new AJS.$.Deferred;

      cmisConfluence.initPageInfo().done(function(info) {
        d.resolve(info);
      }).fail(function(error) {
        d.reject({
          body: errorPrefix + AJS.I18n.getText('alfresco.for.confluence.ajax.error.info'),
          error: error
        });
      });

      return d.promise();

    })().pipe(function(data) {

      // フォルダマッピングが設定されていない場合はCMISのセッションを作成しない
      if (!data.isFederatable()) {
        d.resolve(data);
        return ;
      }

      cmisConfluence.initCmisSession(data, true).done(function(data, cmisSession) {

        // 表示権限がない場合は表示しない
        if (!data.permissions.panel_browse && !data.permissions.panel_browse_without_account) {
          d.reject({
            body: AJS.I18n.getText('alfresco.for.confluence.ajax.error.noauthorized')
          });
          return ;
        }

        // ライセンスが無効な場合は表示しない
        if (cmisConfluence.isInvalidLicense()) {
          d.reject({ body: errorPrefix + AJS.I18n.getText('alfresco.for.confluence.ajax.error.license') });
          return ;
        }

        // ユーザーへ認証登録を促す
        if (attachmentPermission.shouldNavigateAccountRegistration(data.permissions)) {
          d.reject({body: AJS.I18n.getText('alfresco.for.confluence.ajax.error.token') + AJS.I18n.getText('alfresco.for.confluence.ajax.error.go-to-profile', cmisConfluence.getUserProfilePanelUrl())});
          return ;
        }

        // 最大ログイン試行回数を超えた場合はユーザーにログイン確認とリセットを促す
        if (attachmentPermission.isOverMaximumLoginAttemptAllowed(data.permissions)) {
          d.reject({body: AJS.I18n.getText('alfresco.for.confluence.ajax.error.reset-failed-login-count', cmisConfluence.getUserProfilePanelUrl())});
          return ;
        }

        // 最大ログイン試行回数を超えた場合（admin profile時）
        if (cmisConfluence.isOverMaximumLoginAttemptAllowed()) {
          d.reject({body: AJS.I18n.getText('alfresco.for.confluence.ajax.error.session')});
          return ;
        }

        permissions = $.extend(data.permissions, { document_createissue: false });

        d.resolve({
          data: data,
          cmisSession: cmisSession,
          permissions: permissions
        });
      }).fail(function(error) {

        d.reject({
          body: errorPrefix + AJS.I18n.getText('alfresco.for.confluence.ajax.error.session'),
          error: error
        });

      });

    });
    return d.promise();
  }

  return {
    init: init,
    getPermissions: function() {
      return $.extend(true, {}, permissions);
    }
  }
});
