/*
 * Copyright 2016 Ricksoft Co., Ltd.
 * All rights reserved.
 */
define('alfresco-macro/linked-document',
    ['jquery', 'misc/BlobUtil', 'cmis/cmisconfluence', 'cmis/cmispreview', 'cmis/cmisproperty', 'cmis/confluence-error-handler', 'attachments/attachment-permission'],
    function($, blobUtil, cmisConfluence, preview, property, errorHandler, attachmentPermission) {'use strict'
  
  var HIDDEN_CLASS = 'hidden';
  var LOADING_CLASS = "loading-documents";
  var ERROR_PREFIX = "Alfresco Document Macro: ";

  function LinkedDocumentMacro(el, cmisSession, permissions) {

    this.$el_ = $(el);
    this.cmisSession = cmisSession;
    this.permissions = permissions;
    
    this.init_().done(function() {
      
    }).fail(function() {
      
    });
  }

  LinkedDocumentMacro.prototype.displays = {thumbnail: true};

  LinkedDocumentMacro.prototype.dateformat_ = 'YYYY/MM/DD';

  /**
   * 初期化
   */
  LinkedDocumentMacro.prototype.init_ = function() {

    var self = this;
    var d = new AJS.$.Deferred;

    var docId = self.$el_.attr('cmis-doc-id');
    var displayMode = self.$el_.attr('display-mode');
    var thumbnailSize = self.$el_.attr('thumbnail-size');

    self.render_(docId, thumbnailSize, displayMode).done(function() {

      $("." + LOADING_CLASS, self.$el_).addClass(HIDDEN_CLASS);

      d.resolve();
    }).fail(function(error) {
      errorHandler.showError(self.$el_.empty(), {
        body: ERROR_PREFIX + AJS.I18n.getText('alfresco.for.confluence.ajax.error.document.render') + docId,
        error: error
      });
      d.reject();
    });
    
    return d.promise();
    
  }

  LinkedDocumentMacro.prototype.getRenderDocumentParams_ = function (doc) {
    var self = this;
    return attachmentPermission.setToolOperations({
      doc: doc,
      href: doc.getContentStreamURL(true)
    }, doc, self.permissions);
  }

  LinkedDocumentMacro.prototype.render_ = function(docId, thumbnailSize, displayMode) {
    var self = this;
    var d = new AJS.$.Deferred;
    var doc;

    self.cmisSession.getObject(docId, false, {'includeAllowableActions':true}).pipe(function(_doc) {
      doc = _doc;
      return cmisConfluence.getPreviewLink(doc);
    }).pipe(function(previewLink, previewType) {

      self.getRenderDocumentParams_(doc, thumbnailSize).done(function(params) {
        var $template;

        if (displayMode == 'thumbnail') {
          $template = $(Confluence.Templates.alfrescoLinkedDocument.thumbnail(params));
        } else {
          $template = $(Confluence.Templates.alfrescoLinkedDocument.link(params));
        }

        self.$el_.append($template);

        $template.find('.preview').click(function (e) {
          e.preventDefault();
          preview.doPreview(doc, previewType, previewLink, self.permissions);
          return false;
        });

        var contentHtmls = [];
        if (params.operations.document_property) {
          contentHtmls.push('<button class="aui-button property"><span class="aui-icon aui-icon-small aui-iconfont-details"></span></button>');
        }
        if (params.operations.document_download) {
          contentHtmls.push('<button class="aui-button download"><span class="aui-icon aui-icon-small aui-iconfont-devtools-clone"></span></button>');
        }

        if (contentHtmls.length > 0) {
          AJS.InlineDialog($template, 'alfresco-document', function(content, trigger, showPopup) {
            content.html( contentHtmls.join('') );
            content.find('button.property').click(function(e) {
              e.preventDefault();
              property.doProperty(self, doc, self.dateformat_);
              return false;
            });
            content.find('button.download').click(function(e) {
              e.preventDefault();
              doc.download();
              return false;
            });
            showPopup();
            return false;
          }, {onHover:true, width:(contentHtmls.length*45)-(contentHtmls.length == 1 ? 5 : 0)});
        }

        var $img = $template.find("img.doc-thumbnail");
        thumbnailSize = thumbnailSize && thumbnailSize > 0 ? thumbnailSize : 100;
        $img.css({width:thumbnailSize+'px', height:'auto'});

        cmisConfluence.getImgPreview(doc).done(function(data) {
          blobUtil.binary2dataURISheme(data, "image/jpeg").done(function (dataURIScheme) {
            if (dataURIScheme) {
              $template.find("img.doc-thumbnail").attr("src", dataURIScheme);
            }
          }).fail(function (error) {
          });
        }).fail(function() {
        });

        d.resolve();
      });

    }).fail(function() {
      d.reject();
    });

    return d.promise();
  }
  
  return {
    setupMacro: function(el, cmisSession, permissions) {
      return new LinkedDocumentMacro(el, cmisSession, permissions);
    },

    getErrorPrefix: function() {
      return ERROR_PREFIX;
    }
  };
});

AJS.toInit(function() {

  require(['alfresco-macro/linked-document', 'alfresco-macro/macroCommon', 'cmis/confluence-error-handler'], function(main, macroCommon, errorHandler) {

    var $els = AJS.$('.cmis-linked-document');

    macroCommon.init(main.getErrorPrefix()).done(function(initData) {

      AJS.$.each($els, function(i, el) {
        main.setupMacro(el, initData.cmisSession, initData.permissions);
      });

    }).fail(function(error) {

      AJS.$.each($els, function(i, el) {
        errorHandler.showError($(el).empty(), error);
      });

    })

  });
});
