/*
 * Copyright 2016 Ricksoft Co., Ltd.
 * All rights reserved.
 */
define('cmis/cmisversion', ['jquery', 'cmis/cmisconfluence', 'cmis/confluence-error-handler', 'attachments/attachment-permission'], function($, cmisConfluence, errorHandler, attachmentPermission) {

  var DIALOG_ID = 'cmisversion-dialog';
  var DIALOG_SECTION = '<section role="dialog" id="'+DIALOG_ID+'" class="aui-layer aui-dialog2 aui-dialog2-medium loadingInProgress" aria-hidden="true"></section>';
  var HIDDEN_CLASS = 'hidden';
  var LOADING_CLASS = "loading-documents";
  /**
   * バージョニングを行う
   * @param {CmisListView} invokder
   * @param {CmisDocument} doc
   * @param {string} dateformat
   */
  var doVersion = function(invoker, doc, dateformat) {
    
    if ($('#'+DIALOG_ID).length <= 0) {
      $('body').append(DIALOG_SECTION);
    }

    var ajsDlg = AJS.dialog2("#"+DIALOG_ID);
    
    render($("#"+DIALOG_ID), invoker, doc, dateformat);
    
    ajsDlg.show();
    
  }

  /**
   *
   * @param context
   * @param invoker
   * @param doc
   * @param dateformat
   */
  function render(context, invoker, doc, dateformat) {
    var dialogMethod = cmisConfluence.isGreaterThanOrEqualTo(AJS.version, "9.0") ? 'versionDialog2' : 'versionDialog';
    var template = $(JIRA.Templates.cmisversion[dialogMethod]({
      filename: doc.name,
      version: doc.versionLabel
    }));
    var template_frame = $(JIRA.Templates.cmisversion.frame());
    context.empty().append(template);
    $(".versions-content", context).append(template_frame);
    
    var cmisSession = doc.cmisSession;
    var versionSeriesId = doc.versionSeriesId;
    var allVersions = null;
    
    (function(){
      
      $("." + LOADING_CLASS, template).removeClass(HIDDEN_CLASS);
      
      return invoker._getRenderDocumentParams(doc);

    })().pipe(function (original_params) {

      var d = new AJS.$.Deferred;

      doc.getVersions(versionSeriesId).done(function (versions) {
        d.resolve(original_params, versions);
      }).fail(function () {
        d.reject();
      });

      return d.promise();

    }).pipe(function(original_params, versions) {

      var d = new AJS.$.Deferred;

      allVersions = versions;
      
      cmisSession.getObjectByIds(getObjectIds(versions), false, {'includeAllowableActions':true}).done(function (docs) {
        d.resolve(original_params, docs);
      }).fail(function() {
        d.reject();
      });

      return d.promise();
      
    }).pipe(function(original_params, docs) {
      
      sortVersions(docs);
      
      $.each(docs, function(i, doc) {

        invoker._getRenderDocumentParams(doc).done(function (param) {

          if (i == 0) {
            param.operations.document_revert = false;
          } else {
            param.operations.document_revert = original_params.operations.document_newversion;
          }

          var template_version = $(JIRA.Templates.cmisversion.version(param));

          if (i == 0) {
            $(".cmis-version-latest", template_frame).append(template_version);
          } else {
            $(".cmis-version-past", template_frame).append(template_version);
          }

          template_version.find(".download").click(doc, _doDownload);
          template_version.find(".revert").click({
            'id': doc.id,
            'cmisSession': cmisSession,
            'versionSeriesId': versionSeriesId,
            'dateformat': dateformat,
            'template': template,
            'invoker': invoker,
          }, _doRevert);

        });
        
      });

      $(".cmis-version-latest", template_frame).removeClass(HIDDEN_CLASS);
      $(".folder-info-latest", template_frame).removeClass(HIDDEN_CLASS);
      if (allVersions.length && allVersions.length > 1) {
        $(".cmis-version-past", template_frame).removeClass(HIDDEN_CLASS);
        $(".folder-info-past", template_frame).removeClass(HIDDEN_CLASS);
      }
      
    }, function(error) {
      
      errorHandler.showError($(".messages", "#"+DIALOG_ID), {
        body: AJS.I18n.getText('alfresco.for.confluence.ajax.error.version.render'),
        error: error
      });
      
    }).always(function() {
      
      $("." + LOADING_CLASS, template).addClass(HIDDEN_CLASS);
      
    });
    
  }
  
  function clear(context) {
    $(".cmis-version-latest", context).empty();
    $(".cmis-version-past", context).empty();
  }
  
  function sortVersions(versions) {
    versions.sort(function (a, b) {
      function compare(a, b) {
        if (!a || a > b) {
          return -1;
        }
        if (!b || a < b) {
          return 1;
        }
        return 0;
      }

      function getMajorVersion(version) {
        return 'pwc' !== version ? new Number(version.split(".")[0]) : undefined;
      }

      function getMinorVersion(version) {
        return 'pwc' !== version ? new Number(version.split(".")[1]) : undefined;
      }

      var result = compare(getMajorVersion(a.versionLabel), getMajorVersion(b.versionLabel));
      if (result == 0) {
        result = compare(getMinorVersion(a.versionLabel), getMinorVersion(b.versionLabel));
      }
      return result;
    });
  }
  
  function getObjectIds(versions) {
    return $(versions).map(function(index, version){
      return version.id
    });
  }
  
  /**
   * ダウンロードを行う
   * @param
   */
  function _doDownload(e) {
    e.preventDefault();
    
    var doc = e.data;
    doc.download();
  }
  
  /**
   * バージョン差し戻しを行う
   * @param
   */
  function _doRevert(e) {
    e.preventDefault();

    var invoker = e.data.invoker;
    var previousId = e.data.id;
    var versionSeriesId = e.data.versionSeriesId;
    var dateformat = e.data.dateformat;
    var cmisSession = e.data.cmisSession;
    var template = e.data.template;
    var remoteUser = $("meta[name=ajs-remote-user]").attr("content");
    
    (function(){
      
      $("." + LOADING_CLASS, template).removeClass(HIDDEN_CLASS);
      return cmisSession.getObject(previousId);
      
    })().pipe(function(previousDocument) {
      
      return previousDocument.getContentStream();
      
    }).pipe(function(previousContent) {
      
      var d = new AJS.$.Deferred;
      
      cmisSession.getObject(versionSeriesId).done(function(latestDocument) {
        d.resolve(latestDocument, previousContent);
      }).fail(function(error) {
        d.reject(error);
      });
      
      return d.promise();
      
    }).pipe(function(latestDocument, previousContent) {
      
      var d = new AJS.$.Deferred;
      
      latestDocument.cancelCheckOutIfPossible().done(function() {
        d.resolve(latestDocument, previousContent);
      }).fail(function(error) {
        d.reject(error);
      });
      
      return d.promise();
      
    }).pipe(function(latestDocument, previousContent) {
      
      return latestDocument.update(previousContent, {'cm:author':remoteUser});
      
    }).pipe(function(updatedDocument) {
      
      var dialog = $("#"+DIALOG_ID);
      clear(dialog);
      cmisConfluence.getDocumentById(updatedDocument.id).done(function(doc) {
        render(dialog, invoker, doc, dateformat);
      });
      $("." + LOADING_CLASS, template).addClass(HIDDEN_CLASS);
      
    }, function(error) {

      setError(error);
      $("." + LOADING_CLASS, template).addClass(HIDDEN_CLASS);
      
    });
    
  }
  
  function setError(error) {
    if ("409" === error.response.status) {
      errorHandler.showError($(".messages", "#"+DIALOG_ID), {
        body: AJS.I18n.getText('alfresco.for.confluence.ajax.error.version.revert.locked'),
        error: error
      });
    } else {
      errorHandler.showError($(".messages", "#"+DIALOG_ID), {
        body: AJS.I18n.getText('alfresco.for.confluence.ajax.error.version.revert'),
        error: error
      });
    }
  }

  return {
    doVersion: doVersion,
  }
});
