/*
 * Copyright 2016 Ricksoft Co., Ltd.
 * All rights reserved.
 */
define('cmis/cmispreview', ['jquery', 'cmis/cmisconfluence'], function($, cmisConfluence) {

  var PLUGIN_KEY = 'jp.ricksoft.plugins.alfresco-for-confluence';
  var RESOURCE_KEY = 'cmispreview-resources';
  var DIALOG_ID = 'cmispreview-dialog';
  var DIALOG_SECTION = '<section role="dialog" id="'+DIALOG_ID+'" class="aui-layer aui-dialog2 aui-dialog2-xlarge loadingInProgress" aria-hidden="true"></section>';
  var HTML_VIEWER = AJS.params.baseUrl + "/plugins/alfresco4confluence/alfrescopdfviewer.action";

  /**
   * プレビューを行う
   * @param {CmisDocument} doc
   * @param {string} previewType
   * @param {string} url
   * @param {object} permissions
   */
  var doPreview = function(doc, previewType, url, permissions) {
    
    if ($('#'+DIALOG_ID).length <= 0) {
      $('body').append(DIALOG_SECTION);
    }
    
    var param = {
        filename: doc.name,
        version: doc.versionLabel
    };

    var dialogMethod = cmisConfluence.isGreaterThanOrEqualTo(AJS.version, "9.0") ? 'previewDialog2' : 'previewDialog';
    var template = $(JIRA.Templates.cmispreview[dialogMethod](param)),
        dlg = $("#"+DIALOG_ID).empty().append(template),
        ajsDlg = AJS.dialog2("#"+DIALOG_ID);
    
    if ('pdf' === previewType) {

      var splitFileExtension = function (filename) {
        return filename.split(/\.(?=[^.]+$)/);
      }

      var cmisSession = doc.cmisSession;
      var urlWithDownloadPdfFileName = url + "#" + splitFileExtension(doc.name)[0] + ".pdf";
      var options = {
        'httpHeaders':(function() {
          if (cmisSession.authType == 'Basic') {
            return { 'Authorization': cmisSession.token };
          }
          if (cmisSession.authType == 'WSSE') {
            return { 'X-WSSE' : cmisSession.token };
          }
         })(),
        'permissions': permissions
      };

      var previewContent = $('.preview-content', dlg).append($(JIRA.Templates.cmispreview.previewPdf({
        src: HTML_VIEWER,
        width: "100%",
        height: "100%"
      })));

      $('#cmis-preview-pdf').on('load', function(e) {
        this.contentWindow.initializeViewer(urlWithDownloadPdfFileName, options);
      });
      
    } 
    
    if ('movie' === previewType) {
      
      var previewContent = $('.preview-content', dlg).append(JIRA.Templates.cmispreview.previewMovie());
      
      doc.getContentStream(false).done(function(data) {
        var mimetype = doc.succinctProperties["cmis:contentStreamMimeType"];
        var video = $('.movie-content', previewContent).attr({
          src: (URL||webkitURL).createObjectURL(data),
          type: mimetype,
          width: previewContent.width(),
          height: previewContent.height()
        }).get(0);
        $('.aui-dialog2-header-close', dlg).click(function(e) {
          e.preventDefault();
          video.pause();
          ajsDlg.hide();
        });
        // 常にブランクが返ってくるので判定ができない。codecsが必要?
        //if(video.canPlayType && !video.canPlayType(mimetype).match(/^(probably|maybe)$/)){
        //}
      });
      
    }
    
    if ('image' === previewType) {
      
      var imageView = $('<div />', {'class': 'preview-content-image'});
      var previewContent = $('.preview-content', dlg).append(imageView);
      
      doc.getContentStream(false).done(function(data) {
        
        imageView.append($(JIRA.Templates.cmispreview.previewImage())
          .attr({
            src: (URL||webkitURL).createObjectURL(data),
            type: doc.succinctProperties["cmis:contentStreamMimeType"]
          }).load(function() {
            var imgWidth = this.width;
            var imgHeight = this.height;
            var innerWidth = previewContent.width();
            var innerHeight = previewContent.height();
            if (imgHeight >= innerHeight) {
              var ratio = innerHeight / imgHeight;
              imgHeight = innerHeight;
              imgWidth = imgWidth * ratio;
            }
            if (imgWidth >= innerWidth) {
              var ratio = innerWidth / imgWidth;
              imgWidth = innerWidth;
              imgHeight = imgHeight * ratio;
            }
            this.height = imgHeight;
            this.width = imgWidth;

            imageView.find("img.image-content").css({
              left:((innerWidth-imgWidth)/2)+"px",
              top:((innerHeight-imgHeight)/2)+"px"
            });
          }).error(function(){
            $(this).attr('src', getNoImage());
          })
        );

       });
      
    }

    ajsDlg.show();
  }
  
  /**
   * 存在しないことを示すイメージを取得
   * @param
   */
  var getNoImage = function(e) {
    return contextPath + "/download/resources/" + PLUGIN_KEY + ":" + RESOURCE_KEY + "/images/noimage.png";
  }

  return {
    doPreview: doPreview,
  }
});
