/*
 * Copyright 2016 Ricksoft Co., Ltd.
 * All rights reserved.
 */
define('attachments/attachment-permission', ['jquery', 'CMIS', 'cmis/cmisconfluence'],
  function ($, CMIS, cmisconfluence) {

    var object = {};

    /**
     * デフォルトのアクション定義
     * @type {{cmis:document: {document_create: boolean, document_download: boolean, document_preview: boolean, document_version: boolean, document_property: boolean, document_push: boolean, document_pull: boolean, document_remove: boolean, document_link: boolean, document_all_unlink: boolean, document_own_unlink: boolean, document_edit: boolean, document_createissue: boolean, document_favorite: boolean, document_opendetail: boolean}, cmis:folder: {document_create: boolean, folder_create: boolean, folder_remove: boolean, folder_favorite: boolean, document_search: boolean, document_sort: boolean}}}
     */
    var default_actions = {
      'cmis:document': {
        document_create: true,
        document_download: true,
        document_preview: true,
        document_version: true,
        document_property: true,
        document_push: false, // push機能はConfluenceには存在しない
        document_pull: false, // pull機能はConfluenceには存在しない
        document_remove: true,
        document_link: true,
        document_all_unlink: true,
        document_own_unlink: true,
        document_edit: true,
        document_createissue: true,
        document_favorite: true,
        document_sharedlinks: true,
        document_opendetail: true
      },
      'cmis:folder': {
        document_create: true,
        folder_create: true,
        folder_remove: true,
        folder_favorite: true,
        document_search: true,
        document_sort: true,
      }
    };

    var readonly_mode_actions = {
      'cmis:document': {
        document_create: false,
        document_version: false,
        document_property: false,
        document_remove: false,
        document_link: false,
        document_all_unlink: false,
        document_own_unlink: false,
        document_edit: false,
        document_favorite: false,
        document_sharedlinks: false,
      },
      'cmis:folder': {
        document_create: false,
        folder_create: false,
        folder_remove: false,
        folder_favorite: false,
      }
    };

    object.setToolOperations = function (params, item, permissions, workingCopyescalation) {

      var self = this;

      return (function () {

        if (item.isPrivateWorkingCopy || !item.versionSeriesCheckedOutId) {

          var d = new AJS.$.Deferred;

          d.resolve();

          return d.promise();

        }

        // 元の文書からもチェックイン、チェックアウト、チェックアウトのキャンセルのメニューを表示するために作業コピーを持っていたらそれを取得して返す。
        return cmisconfluence.getDocumentById(item.versionSeriesCheckedOutId);

      })().pipe(function (pwc) {

        var allowableActions = item.allowableActions;

        var actions = self.getItemActions(item, permissions);

        // 作業コピーがあれば、そちらのチェックアウト、チェックイン、チェックアウトのキャンセルの許可権限を利用して、元の文書からもこれらの操作ができるようにする。
        if (pwc) {

          allowableActions.canCheckOut = pwc.allowableActions.canCheckOut;

          allowableActions.canCheckIn = pwc.allowableActions.canCheckIn;

          allowableActions.canCancelCheckOut = pwc.allowableActions.canCancelCheckOut;

        }

        if (item.baseTypeId == 'cmis:document') {
          var operations = {
            "document_link": actions.document_link && !params.isPrivateWorkingCopy && isEnableLink(params.link),
            "document_unlink": (actions.document_all_unlink || actions.document_own_unlink) && !params.isPrivateWorkingCopy && isEnableUnlink(params.link),
            "document_newversion": actions.document_create && (allowableActions.canCheckOut || allowableActions.canCheckIn) && params.lockType != 'WRITE_LOCK',
            "document_editonline": actions.document_edit && allowableActions.canCheckOut && !params.versionSeriesCheckedOutId && params.lockType != 'WRITE_LOCK' && cmisconfluence.getAccessType() == 'WithOwnProfile' && params.canOnlineEdit,
            "document_editoffline": actions.document_edit && allowableActions.canCheckOut && !params.versionSeriesCheckedOutId && params.lockType != 'WRITE_LOCK' && cmisconfluence.getAccessType() == 'WithOwnProfile',
            "document_canceledit": actions.document_edit && (allowableActions.canCancelCheckOut && params.versionSeriesCheckedOutId) && cmisconfluence.getAccessType() == 'WithOwnProfile',
            "document_download": actions.document_download && allowableActions.canGetContentStream && params.href && params.href.length > 0,
            "document_preview": actions.document_preview && allowableActions.canGetContentStream,
            "document_version": actions.document_version,
            "document_property": actions.document_property && allowableActions.canUpdateProperties,
            "document_remove": actions.document_remove && allowableActions.canDeleteObject && params.isPrivateWorkingCopy == false,
            "document_favorite": actions.document_favorite && params.isPrivateWorkingCopy == false && cmisconfluence.getAccessType() == 'WithOwnProfile',
            "document_sharedlinks": self.isEnableSharedLinks(actions),
            "document_opendetail": actions.document_opendetail && params.shareDetailUrl && cmisconfluence.getAccessType() == 'WithOwnProfile',
            "document_createissue": actions.document_createissue,
          };

          return $.extend(params, {
            "operations": operations,
            "dropdownOpt": (operations.folder_create || operations.folder_remove),
            "dropdownAct": (operations.document_link || operations.document_unlink
              || operations.document_newversion || operations.document_editonline
              || operations.document_canceledit || operations.document_editoffline
              || operations.document_download || operations.document_preview
              || operations.document_version || operations.document_property
              || operations.document_remove),
          });
        }
        if (item.baseTypeId == 'cmis:folder') {
          var operations = {
            "document_upload": actions.document_create && allowableActions.canCreateDocument,
            "document_search": actions.document_search,
            "document_sort": actions.document_sort,
            "folder_create": actions.folder_create && allowableActions.canCreateFolder,
            "folder_remove": actions.folder_remove && allowableActions.canDeleteObject && allowableActions.canDeleteTree,
            "folder_favorite": actions.folder_favorite && cmisconfluence.getAccessType() == 'WithOwnProfile'
          };

          return $.extend(params, {
            "operations": operations,
            "dropdownOpt": (operations.folder_create || operations.folder_remove),
            "dropdownAct": (operations.folder_create || operations.folder_remove),
          });
        }
        return {};

      });

    }

    /**
     * item(folder or document)から可能なアクションを取得する
     * @param item
     * @param permissions
     * @returns {*}
     */
    object.getItemActions = function (item, permissions) {
      var self = this;

      if (!item) {
        throw new Error('Item is missing...');
      }
      if (!item.allowableActions) {
        throw new Error('AllowableActions is missing on [' + item.name + ']...');
      }

      var actions = $.extend({}, default_actions[item.baseTypeId]);

      if (permissions) {
        actions = $.extend(actions, filterObject(permissions, function(key, value) {
          return !value;
        }));
      }

      if (item.linkObject) {
        // リンクの場合は、お気に入りと共有リンクは無効化する
        if (item.baseTypeId == 'cmis:document') {
          actions.document_favorite = false;
          actions.document_sharedlinks = false;
        } else if (item.baseTypeId == 'cmis:folder') {
          actions.folder_favorite = false;
        }
      }

      if (cmisconfluence.isReadOnlyModeEnabled()) {
        actions = $.extend(actions, readonly_mode_actions[item.baseTypeId]);
      }

      return actions;

      function filterObject(obj, callback){
        var result = {};
        for(var key in obj) {
          if(obj.hasOwnProperty(key)) {
            if(callback(key, obj[key])) {
              result[key] = obj[key];
            }
          }
        }
        return result;
      }

    }

    /**
     * ドキュメントに対してリンクが可能であるか確認する
     * 表示している課題がすでにリンク済みの場合はfalse、そうでない場合はtrueを返す。
     * 課題を表示していない(プロジェクトビュー)場合はtrueを返す。
     * @param links
     * @returns {boolean}
     */
    function isEnableLink(links) {
      var pageId = cmisconfluence.getPageId();
      if (!pageId) {
        return true;
      }
      if (!links) {
        return true;
      }
      for(var i = 0; i < links.length; i++) {
        var link = links[i];
        if ((link.pageId+'') === pageId) {
          return false;
        }
      }
      return true;
    }

    /**
     * ドキュメントに対してリンク解除が可能であるか確認する。
     * 表示している課題がすでにリンク済み、尚且つ、リンク解除の権限がある場合はtrue、そうでない場合はfalseを返す。
     * 課題を表示していない(プロジェクトビュー)場合はtrueを返す。
     * @param links
     * @returns {boolean}
     */
    function isEnableUnlink(links) {
      var pageId = cmisconfluence.getPageId();
      if (!pageId) {
        return true;
      }
      if (!links) {
        return false;
      }
      for(var i = 0; i < links.length; i++) {
        var link = links[i];
        if ((link.pageId+'') === pageId && link.enableUnlink === true) {
          return true;
        }
      }
      return false;
    }

    object.isEnableBrowsePanel = function (permissions) {
      return !permissions.panel_browse && !permissions.panel_browse_without_account;
    }

    object.isEnableBrowsePanelWithoutAccount = function (permissions) {
      // return !(cmisjira.hasUserCredential() && permissions.panel_browse) && permissions.panel_browse_without_account;
      return permissions.panel_browse_without_account;
    }

    object.shouldNavigateAccountRegistration = function (permissions) {
      return cmisconfluence.getAccessType() == 'WithOwnProfile' && (!cmisconfluence.hasUserCredential() && permissions.panel_browse && !permissions.panel_browse_without_account);
    }

    object.isEnableFavorite = function (permissions) {
      return cmisconfluence.getAccessType() == 'WithOwnProfile' && (permissions.document_favorite != false || permissions.folder_favorite != false)
    }

    object.isOverMaximumLoginAttemptAllowed = function (permissions) {
      return cmisconfluence.getAccessType() == 'WithOwnProfile' && (cmisconfluence.isLimitMaximumLoginAttemptAllowed() && cmisconfluence.isOverMaximumLoginAttemptAllowed());
    }

    /**
     * Alfrescoの共有リンクが利用可能か
     */
    object.isEnableSharedLinks = function(permissions) {

      if (cmisconfluence.getAccessType() != 'WithOwnProfile') {
        // WithOwnProfile 時は利用不可
        return false;
      }

      var version = cmisconfluence.getCmisSession().getProductVersion() || "";
      if ('5.2'.localeCompare(version) > 0) {
        // Version が 5.2 未満の場合は利用不可
        return false;
      }

      if (permissions.document_sharedlinks != true) {
        return false;
      }

      return true;
    }

    object.isEnableUploadForCreate = function (folder) {
      return folder.allowableActions.canCreateDocument;
    }

    object.isEnableUploadForUpdate = function (document) {
      return document.allowableActions.canCheckOut || document.allowableActions.canCheckIn;
    }

    object.isEnableUploadForNewVersion = function (document) {
      return document.allowableActions.canCheckIn;
    }
    return object;

  });
