/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.commons.impl;

import java.net.URI;
import org.apache.chemistry.opencmis.commons.enums.AclPropagation;
import org.apache.chemistry.opencmis.commons.enums.IncludeRelationships;
import org.apache.chemistry.opencmis.commons.enums.RelationshipDirection;
import org.apache.chemistry.opencmis.commons.enums.UnfileObject;
import org.apache.chemistry.opencmis.commons.enums.VersioningState;
import org.apache.chemistry.opencmis.commons.impl.IOUtils;
import org.apache.chemistry.opencmis.commons.impl.ReturnVersion;

public class UrlBuilder {
    private final StringBuilder urlPart;
    private final StringBuilder queryPart;
    private static final char[] RFC7232_RESERVED = ";?:@&=+$,[]".toCharArray();

    public UrlBuilder(String url) {
        if (url == null) {
            throw new IllegalArgumentException("URL must be set");
        }
        this.urlPart = new StringBuilder(128);
        this.queryPart = new StringBuilder(128);
        int qm = url.indexOf(63);
        if (qm == -1) {
            this.urlPart.append(url);
        } else {
            this.urlPart.append(url.substring(0, qm));
            if (qm < url.length()) {
                this.queryPart.append(url.substring(qm + 1));
            }
        }
    }

    public UrlBuilder(String scheme, String host, int port, String path) {
        if ("http".equalsIgnoreCase(scheme) && port == 80) {
            port = -1;
        }
        if ("https".equalsIgnoreCase(scheme) && port == 443) {
            port = -1;
        }
        this.urlPart = new StringBuilder(128);
        this.queryPart = new StringBuilder(128);
        this.urlPart.append(scheme);
        this.urlPart.append("://");
        this.urlPart.append(host);
        if (port > 0) {
            this.urlPart.append(':').append(port);
        }
        if (path != null && path.length() > 0) {
            if (this.urlPart.charAt(this.urlPart.length() - 1) != '/') {
                this.urlPart.append('/');
            }
            if (path.charAt(0) == '/') {
                path = path.substring(1);
            }
            this.urlPart.append(UrlBuilder.quoteURIPathComponent(path, true));
        }
    }

    public UrlBuilder(UrlBuilder urlBuilder) {
        if (urlBuilder == null) {
            throw new IllegalArgumentException("UrlBuilder must be set");
        }
        this.urlPart = new StringBuilder(urlBuilder.urlPart);
        this.queryPart = new StringBuilder(urlBuilder.queryPart);
    }

    public UrlBuilder addParameter(String name, Object value) {
        if (name == null || value == null) {
            return this;
        }
        String valueStr = UrlBuilder.normalizeParameter(value);
        if (this.queryPart.length() > 0) {
            this.queryPart.append('&');
        }
        this.queryPart.append(name);
        this.queryPart.append('=');
        this.queryPart.append(IOUtils.encodeURL(valueStr));
        return this;
    }

    public UrlBuilder addParameter(String name) {
        if (name == null) {
            return this;
        }
        if (this.queryPart.length() > 0) {
            this.queryPart.append('&');
        }
        this.queryPart.append(name);
        return this;
    }

    public UrlBuilder addPathSegment(String pathSegment) {
        return this.addPathPart(pathSegment, true);
    }

    public UrlBuilder addPath(String path) {
        return this.addPathPart(path, false);
    }

    protected UrlBuilder addPathPart(String part, boolean quoteSlash) {
        if (part == null || part.length() == 0) {
            return this;
        }
        if (this.urlPart.charAt(this.urlPart.length() - 1) != '/') {
            this.urlPart.append('/');
        }
        if (part.charAt(0) == '/') {
            part = part.substring(1);
        }
        this.urlPart.append(UrlBuilder.quoteURIPathComponent(part, quoteSlash));
        return this;
    }

    public static String quoteURIPathComponent(String s, boolean quoteSlash) {
        URI uri;
        if (s.length() == 0) {
            return s;
        }
        try {
            uri = new URI("x", s, null);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Illegal characters in: " + s, e);
        }
        String r = uri.toASCIIString().substring(2);
        for (char c : RFC7232_RESERVED) {
            if (r.indexOf(c) < 0) continue;
            r = r.replace(String.valueOf(c), "%" + Integer.toHexString(c));
        }
        if (quoteSlash && r.indexOf(47) >= 0) {
            r = r.replace("/", "%2F");
        }
        return r;
    }

    public static String normalizeParameter(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof IncludeRelationships) {
            return ((IncludeRelationships)((Object)value)).value();
        }
        if (value instanceof VersioningState) {
            return ((VersioningState)((Object)value)).value();
        }
        if (value instanceof UnfileObject) {
            return ((UnfileObject)((Object)value)).value();
        }
        if (value instanceof RelationshipDirection) {
            return ((RelationshipDirection)((Object)value)).value();
        }
        if (value instanceof ReturnVersion) {
            return ((ReturnVersion)((Object)value)).value();
        }
        if (value instanceof AclPropagation) {
            return ((AclPropagation)((Object)value)).value();
        }
        return value.toString();
    }

    public String toString() {
        return this.urlPart.toString() + (this.queryPart.length() == 0 ? "" : "?" + this.queryPart.toString());
    }
}

