/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.client.bindings.spi.webservices;

import java.math.BigInteger;
import org.apache.chemistry.opencmis.client.bindings.spi.BindingSession;
import org.apache.chemistry.opencmis.client.bindings.spi.webservices.AbstractPortProvider;
import org.apache.chemistry.opencmis.client.bindings.spi.webservices.AbstractWebServicesService;
import org.apache.chemistry.opencmis.commons.data.ExtensionsData;
import org.apache.chemistry.opencmis.commons.data.ObjectList;
import org.apache.chemistry.opencmis.commons.enums.IncludeRelationships;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.commons.impl.WSConverter;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisException;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisObjectListType;
import org.apache.chemistry.opencmis.commons.impl.jaxb.DiscoveryServicePort;
import org.apache.chemistry.opencmis.commons.impl.jaxb.EnumIncludeRelationships;
import org.apache.chemistry.opencmis.commons.spi.DiscoveryService;
import org.apache.chemistry.opencmis.commons.spi.Holder;

public class DiscoveryServiceImpl
extends AbstractWebServicesService
implements DiscoveryService {
    private final AbstractPortProvider portProvider;

    public DiscoveryServiceImpl(BindingSession session, AbstractPortProvider portProvider) {
        this.setSession(session);
        this.portProvider = portProvider;
    }

    @Override
    public ObjectList getContentChanges(String repositoryId, Holder<String> changeLogToken, Boolean includeProperties, String filter, Boolean includePolicyIds, Boolean includeACL, BigInteger maxItems, ExtensionsData extension) {
        DiscoveryServicePort port = this.portProvider.getDiscoveryServicePort(this.getCmisVersion(repositoryId), "getContentChanges");
        try {
            javax.xml.ws.Holder<String> portChangeLokToken = WSConverter.convertHolder(changeLogToken);
            javax.xml.ws.Holder<CmisObjectListType> portObjects = new javax.xml.ws.Holder<CmisObjectListType>();
            port.getContentChanges(repositoryId, portChangeLokToken, includeProperties, filter, includePolicyIds, includeACL, maxItems, WSConverter.convert(extension), portObjects);
            WSConverter.setHolderValue(portChangeLokToken, changeLogToken);
            ObjectList objectList = WSConverter.convert((CmisObjectListType)portObjects.value);
            return objectList;
        }
        catch (CmisException e) {
            throw this.convertException(e);
        }
        catch (Exception e) {
            throw new CmisRuntimeException("Error: " + e.getMessage(), e);
        }
        finally {
            this.portProvider.endCall(port);
        }
    }

    @Override
    public ObjectList query(String repositoryId, String statement, Boolean searchAllVersions, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, BigInteger maxItems, BigInteger skipCount, ExtensionsData extension) {
        DiscoveryServicePort port = this.portProvider.getDiscoveryServicePort(this.getCmisVersion(repositoryId), "query");
        try {
            ObjectList objectList = WSConverter.convert(port.query(repositoryId, statement, searchAllVersions, includeAllowableActions, WSConverter.convert(EnumIncludeRelationships.class, includeRelationships), renditionFilter, maxItems, skipCount, WSConverter.convert(extension)));
            return objectList;
        }
        catch (CmisException e) {
            throw this.convertException(e);
        }
        catch (Exception e) {
            throw new CmisRuntimeException("Error: " + e.getMessage(), e);
        }
        finally {
            this.portProvider.endCall(port);
        }
    }
}

