/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.client.bindings.spi.http;

import java.math.BigInteger;
import java.util.Map;
import org.apache.chemistry.opencmis.client.bindings.spi.BindingSession;
import org.apache.chemistry.opencmis.client.bindings.spi.http.DefaultHttpInvoker;
import org.apache.chemistry.opencmis.client.bindings.spi.http.HttpInvoker;
import org.apache.chemistry.opencmis.client.bindings.spi.http.Output;
import org.apache.chemistry.opencmis.client.bindings.spi.http.Response;
import org.apache.chemistry.opencmis.commons.exceptions.CmisBaseException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.commons.impl.ClassLoaderUtil;
import org.apache.chemistry.opencmis.commons.impl.UrlBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DelayingHttpInvoker
implements HttpInvoker {
    private static final Logger LOG = LoggerFactory.getLogger(DelayingHttpInvoker.class);
    public static final String DELEGTAE_HTTP_INVOKER_CLASS = "org.apache.chemistry.opencmis.binding.httpinvoker.delay.delegate.classname";
    public static final String DELAY_TIME = "org.apache.chemistry.opencmis.binding.httpinvoker.delay.delaytime";
    protected static final String DELEGTAE_HTTP_INVOKER = "org.apache.chemistry.opencmis.client.bindings.spi.http.limiter.httpInvoker";
    protected static final String LAST_EXECUTION = "org.apache.chemistry.opencmis.client.bindings.spi.http.limiter.lastExecution";

    @Override
    public Response invokeGET(UrlBuilder url, BindingSession session) {
        this.delay(session);
        return this.getHttpInvoker(session).invokeGET(url, session);
    }

    @Override
    public Response invokeGET(UrlBuilder url, BindingSession session, BigInteger offset, BigInteger length) {
        this.delay(session);
        return this.getHttpInvoker(session).invokeGET(url, session, offset, length);
    }

    @Override
    public Response invokePOST(UrlBuilder url, String contentType, Output writer, BindingSession session) {
        this.delay(session);
        return this.getHttpInvoker(session).invokePOST(url, contentType, writer, session);
    }

    @Override
    public Response invokePUT(UrlBuilder url, String contentType, Map<String, String> headers, Output writer, BindingSession session) {
        this.delay(session);
        return this.getHttpInvoker(session).invokePUT(url, contentType, headers, writer, session);
    }

    @Override
    public Response invokeDELETE(UrlBuilder url, BindingSession session) {
        this.delay(session);
        return this.getHttpInvoker(session).invokeDELETE(url, session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void delay(BindingSession session) {
        session.writeLock();
        try {
            block10: {
                int delayTime = session.get(DELAY_TIME, -1);
                if (delayTime < 0) {
                    if (LOG.isInfoEnabled()) {
                        LOG.info("No delay time configured.");
                    }
                    return;
                }
                Object lastExcution = session.get(LAST_EXECUTION);
                if (lastExcution instanceof Long) {
                    long lastExcutionLong = (Long)lastExcution;
                    long now = System.currentTimeMillis();
                    if (now - lastExcutionLong < (long)delayTime) {
                        try {
                            Thread.sleep((long)delayTime - (now - lastExcutionLong));
                        }
                        catch (InterruptedException e) {
                            if (!LOG.isDebugEnabled()) break block10;
                            LOG.debug("Interrupted sleep", (Throwable)e);
                        }
                    }
                }
            }
            session.put(LAST_EXECUTION, Long.valueOf(System.currentTimeMillis()));
        }
        finally {
            session.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected HttpInvoker getHttpInvoker(BindingSession session) {
        HttpInvoker invoker = (HttpInvoker)session.get(DELEGTAE_HTTP_INVOKER);
        if (invoker != null) {
            return invoker;
        }
        session.writeLock();
        try {
            invoker = (HttpInvoker)session.get(DELEGTAE_HTTP_INVOKER);
            if (invoker != null) {
                HttpInvoker httpInvoker = invoker;
                return httpInvoker;
            }
            try {
                String invokerName = (String)session.get(DELEGTAE_HTTP_INVOKER_CLASS);
                invoker = invokerName == null ? new DefaultHttpInvoker() : (HttpInvoker)ClassLoaderUtil.loadClass(invokerName).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (CmisBaseException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CmisRuntimeException("Delegate HTTP invoker cannot be initialized: " + e.getMessage(), e);
            }
            session.put(DELEGTAE_HTTP_INVOKER, invoker, true);
        }
        finally {
            session.writeUnlock();
        }
        return invoker;
    }
}

