/*
 * Decompiled with CFR 0.152.
 */
package jp.ricksoft.plugins.alfresco.rest.permission;

import com.atlassian.sal.api.message.I18nResolver;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import jp.ricksoft.plugins.alfresco.permission.PermissionKeys;
import jp.ricksoft.plugins.alfresco.rest.permission.ActorBean;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;

@JsonIgnoreProperties(ignoreUnknown=true)
public class FeaturePermissionBean {
    @XmlElement
    private String id;
    @XmlElement
    private String name;
    @XmlElement
    private String title;
    @XmlElement
    private String description;
    @XmlElement
    private List<ActorBean> actors;

    public FeaturePermissionBean() {
        this.actors = Collections.emptyList();
    }

    public FeaturePermissionBean(PermissionKeys permissionKeys, String featureName, List<ActorBean> actors, I18nResolver i18) {
        this.id = permissionKeys.name().toLowerCase();
        this.name = featureName;
        this.actors = actors;
        this.title = i18.getText("alfresco.for.confluence.admin.permission.feature." + this.id);
        this.description = i18.getText("alfresco.for.confluence.admin.permission.feature." + this.id + ".description");
    }

    public String getFeatureId() {
        return this.id;
    }

    public void setFeatureId(String featureId) {
        this.id = featureId;
    }

    public String getFeatureName() {
        return this.name;
    }

    public void setFeatureName(String featureName) {
        this.name = featureName;
    }

    public List<ActorBean> getActors() {
        return this.actors;
    }

    public void setActors(List<ActorBean> actors) {
        this.actors = actors;
    }
}

