/*
 * Decompiled with CFR 0.152.
 */
package jp.ricksoft.plugins.alfresco.permission;

import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.plugin.util.Assertions;
import com.atlassian.user.EntityException;
import com.atlassian.user.Group;
import com.atlassian.user.GroupManager;
import com.atlassian.user.User;
import java.util.List;
import jp.ricksoft.plugins.alfresco.ao.service.FeaturePermissionService;
import jp.ricksoft.plugins.alfresco.ao.service.SpaceConfigService;
import jp.ricksoft.plugins.alfresco.permission.FeaturePermissionManager;
import jp.ricksoft.plugins.alfresco.permission.PermissionKeys;

public class FeaturePermissionManagerImpl
implements FeaturePermissionManager {
    private final FeaturePermissionService featurePermissionService;
    private final GroupManager groupManager;
    private final SpaceConfigService spaceConfigService;

    public FeaturePermissionManagerImpl(FeaturePermissionService featurePermissionService, GroupManager groupManager, SpaceConfigService spaceConfigService) {
        this.featurePermissionService = featurePermissionService;
        this.groupManager = groupManager;
        this.spaceConfigService = spaceConfigService;
    }

    @Override
    public FeaturePermissionService.SeachResult get(Space space, PermissionKeys permissionKey) {
        Long spaceId = space != null ? Long.valueOf(space.getId()) : null;
        return this.featurePermissionService.getSearchResult(spaceId, permissionKey);
    }

    @Override
    public void put(Space space, PermissionKeys permissionKey, List<String> users, List<String> groups) {
        Long spaceId = space != null ? Long.valueOf(space.getId()) : null;
        this.featurePermissionService.clear(spaceId, permissionKey);
        this.featurePermissionService.add(spaceId, permissionKey, users, groups);
    }

    @Override
    public boolean isEnablePermission(Space space) {
        return this.spaceConfigService.isEnableUsageFeaturePermission(space.getId());
    }

    @Override
    public boolean hasPermission(PermissionKeys permissionKey, AbstractPage page, ConfluenceUser user) {
        Assertions.notNull((String)"permissionKey", (Object)((Object)permissionKey));
        Assertions.notNull((String)"page", (Object)page);
        Assertions.notNull((String)"user", (Object)user);
        return this.hasPermission(permissionKey, page.getSpace(), user);
    }

    @Override
    public boolean hasPermission(PermissionKeys permissionKey, Space space, ConfluenceUser user) {
        Assertions.notNull((String)"permissionKey", (Object)((Object)permissionKey));
        Assertions.notNull((String)"page", (Object)space);
        Assertions.notNull((String)"user", (Object)user);
        if (!this.spaceConfigService.find(space.getId()).isEnablePermission()) {
            return true;
        }
        FeaturePermissionService.SeachResult seachResult = this.featurePermissionService.getUnformattedSearchResult(space.getId(), permissionKey);
        user.getKey().getStringValue();
        for (String userkey : seachResult.getUsers()) {
            if (!user.getKey().getStringValue().equals(userkey)) continue;
            return true;
        }
        for (String g : seachResult.getGroups()) {
            try {
                Group group = this.groupManager.getGroup(g);
                if (!this.groupManager.hasMembership(group, (User)user)) continue;
                return true;
            }
            catch (EntityException entityException) {
            }
        }
        return false;
    }

    @Override
    public boolean clearAllPermissions(Space space) {
        for (PermissionKeys permissionKey : PermissionKeys.values()) {
            this.featurePermissionService.clear(space.getId(), permissionKey);
        }
        return true;
    }

    @Override
    public void copyDefaultPermission(Space space) {
        Assertions.notNull((String)"page", (Object)space);
        this.clearAllPermissions(space);
        boolean defaultEnablePermission = false;
        this.spaceConfigService.saveUsageFeaturePermission(space.getId(), defaultEnablePermission);
        for (PermissionKeys key : PermissionKeys.values()) {
            FeaturePermissionService.SeachResult result = this.featurePermissionService.getSearchResult(null, key);
            this.featurePermissionService.add(space.getId(), key, result.getUsers(), result.getGroups());
        }
    }
}

