/*
 * Decompiled with CFR 0.152.
 */
package jp.ricksoft.plugins.alfresco.page;

import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.actions.ViewPageAction;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.user.ConfluenceUser;
import java.util.List;
import jp.ricksoft.plugins.alfresco.ao.entity.MappingFolder;
import jp.ricksoft.plugins.alfresco.ao.service.CredentialService;
import jp.ricksoft.plugins.alfresco.ao.service.MappingFolderService;
import jp.ricksoft.plugins.alfresco.license.LicenseManager;
import jp.ricksoft.plugins.alfresco.rest.permission.FeaturePermissionResourceHelper;

public class AlfrescoBasePageAction
extends ViewPageAction {
    private static final long serialVersionUID = 8438097367111012162L;
    protected LicenseManager licenseManager;
    private CredentialService credentialService;
    private MappingFolderService mappingFolderService;
    private FeaturePermissionResourceHelper featurePermissionResourceHelper;

    protected boolean hasBrowsePermission(AbstractPage page, ConfluenceUser loggeInUser) {
        if (page == null) {
            return false;
        }
        Space space = page.getSpace();
        if (space == null) {
            return false;
        }
        if (this.credentialService.find() == null) {
            return false;
        }
        List<MappingFolder> folders = this.mappingFolderService.getFoldersBySpaceId(space.getId());
        if (folders == null || folders.size() <= 0) {
            return false;
        }
        return this.featurePermissionResourceHelper.canBrowsePanel(page, loggeInUser) || this.featurePermissionResourceHelper.canBrowsePanelWithoutAccount(page, loggeInUser);
    }

    public void setLicenseManager(LicenseManager licenseManager) {
        this.licenseManager = licenseManager;
    }

    public boolean isInvalidLicense() {
        return this.licenseManager.isInvalidLicense();
    }

    public String getInvalidLicenseRedirect() {
        return "license";
    }

    public void setCredentialService(CredentialService credentialService) {
        this.credentialService = credentialService;
    }

    public void setMappingFolderService(MappingFolderService mappingFolderService) {
        this.mappingFolderService = mappingFolderService;
    }

    public void setFaturePermissionResourceHelper(FeaturePermissionResourceHelper featurePermissionResourceHelper) {
        this.featurePermissionResourceHelper = featurePermissionResourceHelper;
    }
}

