/*
 * Decompiled with CFR 0.152.
 */
package jp.ricksoft.plugins.alfresco.ao.service;

import com.atlassian.fugue.Either;
import java.text.SimpleDateFormat;
import java.util.Date;
import jp.ricksoft.plugins.alfresco.ao.entity.CredentialEntity;
import jp.ricksoft.plugins.alfresco.ao.entity.CredentialSecret;

public class CredentialTokenProvider {
    private String alfrescoDisplayUrl;
    private String alfrescoApplicationUrl;
    private String shareDisplayUrl;
    private String authType;
    private String accessType;
    private String username;
    private String token;
    private Integer maximumLoginAttemptAllowed;
    private Integer currentLoginFailedCount;
    private Long lastFailedLoginMillis;
    private Either<CredentialEntity, CredentialSecret> credentialEither;

    public CredentialTokenProvider(String alfrescoDisplayUrl, String alfrescoApplicationUrl, String shareDisplayUrl, String authType, String accessType, String username, String token, Integer maximumLoginAttemptAllowed, Integer currentLoginFailedCount, Long lastFailedLoginMillis, Either<CredentialEntity, CredentialSecret> credentialEither) {
        this.alfrescoDisplayUrl = this.removeTrailingSlash(alfrescoDisplayUrl);
        this.alfrescoApplicationUrl = this.removeTrailingSlash(alfrescoApplicationUrl);
        this.shareDisplayUrl = this.removeTrailingSlash(shareDisplayUrl);
        this.authType = authType;
        this.accessType = accessType;
        this.username = username;
        this.token = token;
        this.maximumLoginAttemptAllowed = maximumLoginAttemptAllowed;
        this.currentLoginFailedCount = currentLoginFailedCount;
        this.lastFailedLoginMillis = lastFailedLoginMillis;
        this.credentialEither = credentialEither;
    }

    public String getAlfrescoDisplayUrl() {
        return this.alfrescoDisplayUrl;
    }

    public String getAlfrescoApplicationUrl() {
        return this.alfrescoApplicationUrl;
    }

    public String getShareDisplayUrl() {
        return this.shareDisplayUrl;
    }

    public String getAuthType() {
        return this.authType;
    }

    public String getAccessType() {
        return this.accessType;
    }

    public String getUsername() {
        return this.username;
    }

    public String getToken() {
        return this.token;
    }

    public Integer getMaximumLoginAttemptAllowed() {
        return this.maximumLoginAttemptAllowed;
    }

    public Integer getCurrentLoginFailedCount() {
        return this.currentLoginFailedCount;
    }

    public Long getLastFailedLoginMillis() {
        return this.lastFailedLoginMillis;
    }

    public boolean isLimitMaximumLoginAttemptAllowed() {
        return this.getMaximumLoginAttemptAllowed() != null && this.getMaximumLoginAttemptAllowed() > 0;
    }

    public boolean isOverMaximumLoginAttemptAllowed() {
        if (!this.isLimitMaximumLoginAttemptAllowed() || this.getCurrentLoginFailedCount() == null) {
            return false;
        }
        return this.getMaximumLoginAttemptAllowed() <= this.getCurrentLoginFailedCount();
    }

    public String getLastFailedLogin() {
        if (this.getLastFailedLoginMillis() == null) {
            return "";
        }
        return new SimpleDateFormat("yyyy/MM/dd hh:mm").format(new Date(this.getLastFailedLoginMillis()));
    }

    public Either<CredentialEntity, CredentialSecret> getCredentialEither() {
        return this.credentialEither;
    }

    String removeTrailingSlash(String url) {
        if (url != null && url.endsWith("/")) {
            url = url.substring(0, url.length() - 1);
        }
        return url;
    }
}

