/*
 * Decompiled with CFR 0.152.
 */
package jp.ricksoft.plugins.alfresco.ao.service;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.confluence.user.ConfluenceUser;
import java.util.Date;
import jp.ricksoft.plugins.alfresco.ao.entity.CredentialEntity;
import jp.ricksoft.plugins.alfresco.ao.entity.CredentialSecret;
import jp.ricksoft.plugins.alfresco.ao.service.CredentialSecretService;
import jp.ricksoft.plugins.alfresco.auth.AuthUtils;
import net.java.ao.DBParam;
import net.java.ao.Query;
import net.java.ao.RawEntity;

public class CredentialSecretServiceImpl
implements CredentialSecretService {
    private final ActiveObjects ao;

    public CredentialSecretServiceImpl(ActiveObjects ao) {
        this.ao = ao;
    }

    @Override
    public CredentialSecret find(int id) {
        return (CredentialSecret)this.ao.get(CredentialSecret.class, (Object)id);
    }

    @Override
    public CredentialSecret find(ConfluenceUser user) {
        CredentialSecret[] entities = (CredentialSecret[])this.ao.find(CredentialSecret.class, Query.select().where("USER_KEY = ?", new Object[]{user.getKey().getStringValue()}));
        if (entities == null || entities.length == 0) {
            return null;
        }
        return entities[0];
    }

    @Override
    public CredentialSecret save(CredentialEntity credentialEntity, ConfluenceUser user, String username, String password) {
        CredentialSecret entity = (CredentialSecret)this.ao.create(CredentialSecret.class, new DBParam[0]);
        String authType = credentialEntity.getAuthType();
        String secret = this.generateSecret(authType, username, password);
        entity.setUserKey(user.getKey().getStringValue());
        entity.setUsername(username);
        entity.setSecret(secret);
        entity.save();
        return entity;
    }

    @Override
    public CredentialSecret update(CredentialEntity credentialEntity, int id, ConfluenceUser user, String username, String password) {
        CredentialSecret entity = this.find(id);
        if (entity == null) {
            return entity;
        }
        String authType = credentialEntity.getAuthType();
        String secret = this.generateSecret(authType, username, password);
        entity.setUserKey(user.getKey().getStringValue());
        entity.setUsername(username);
        entity.setSecret(secret);
        entity.save();
        return entity;
    }

    @Override
    public CredentialSecret updateCurrentLoginFailed(CredentialSecret credentialSecretEntity) {
        if (credentialSecretEntity == null) {
            return credentialSecretEntity;
        }
        Integer totalLoginFailedCount = credentialSecretEntity.getTotalLoginFailedCount();
        Integer currentLoginFailedCount = credentialSecretEntity.getCurrentLoginFailedCount();
        credentialSecretEntity.setTotalLoginFailedCount((totalLoginFailedCount != null ? totalLoginFailedCount : 0) + 1);
        credentialSecretEntity.setCurrentLoginFailedCount((currentLoginFailedCount != null ? currentLoginFailedCount : 0) + 1);
        credentialSecretEntity.setLastFailedLoginMillis(new Date().getTime());
        credentialSecretEntity.save();
        return credentialSecretEntity;
    }

    @Override
    public CredentialSecret resetFailedLoginCount(CredentialSecret credentialSecretEntity) {
        if (credentialSecretEntity == null) {
            return credentialSecretEntity;
        }
        credentialSecretEntity.setCurrentLoginFailedCount(0);
        credentialSecretEntity.save();
        return credentialSecretEntity;
    }

    @Override
    public void delete(int id) {
        CredentialSecret entity = (CredentialSecret)this.ao.get(CredentialSecret.class, (Object)id);
        if (entity == null) {
            return;
        }
        this.ao.delete(new RawEntity[]{entity});
    }

    String generateSecret(String authType, String username, String password) {
        if ("Basic".equals(authType)) {
            return AuthUtils.encodeBase64(username + ":" + password).trim();
        }
        if ("WSSE".equals(authType)) {
            return AuthUtils.encodeMD4(password);
        }
        throw new IllegalArgumentException("The specified authType is not supported. [" + authType + "]");
    }
}

