/*
 * Decompiled with CFR 0.152.
 */
package jp.ricksoft.plugins.alfresco.admin;

import com.atlassian.confluence.spaces.Space;
import com.atlassian.xwork.RequireSecurityToken;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import jp.ricksoft.plugins.alfresco.admin.MappingFolderAction;
import jp.ricksoft.plugins.alfresco.ao.entity.MappingFolder;
import jp.ricksoft.plugins.alfresco.ao.entity.MappingFolderType;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class MappingFolderEditAction
extends MappingFolderAction {
    private static final long serialVersionUID = 6603001717850056130L;
    private static final Logger LOGGER = Logger.getLogger(MappingFolderEditAction.class);
    private Integer folderId;
    private String name;
    private String type = MappingFolderType.PUBLIC.name();
    private String cmisFolderId;
    private Long[] spaceIds;

    @Override
    @RequireSecurityToken(value=true)
    public String execute() {
        if (this.isInvalidLicense()) {
            return this.getInvalidLicenseRedirect();
        }
        this.doValidate();
        if (this.hasErrors()) {
            return "error";
        }
        if (this.folderId != null) {
            MappingFolder folder = this.mappingFolderService.getFolder(this.folderId);
            this.setName(folder.getName());
            this.setType(folder.getType());
            this.setCmisFolderId(folder.getPath().getCmisFolderId());
            this.setSpaceIds(folder.getSpaceIds());
        }
        return "success";
    }

    @RequireSecurityToken(value=true)
    public String doSave() {
        LOGGER.debug((Object)"doSave() start");
        if (this.isInvalidLicense()) {
            return this.getInvalidLicenseRedirect();
        }
        this.doValidate();
        if (StringUtils.isEmpty((CharSequence)this.name)) {
            this.addFieldError("name", this.getText("alfresco.for.confluence.admin.mapping-folder.name.error.empty", this.name));
        }
        if (StringUtils.isEmpty((CharSequence)this.type)) {
            this.addFieldError("type", this.getText("alfresco.for.confluence.admin.mapping-folder.type.error.empty", this.type));
        }
        if (StringUtils.isEmpty((CharSequence)this.cmisFolderId)) {
            this.addFieldError("path", this.getText("alfresco.for.confluence.admin.mapping-folder.folderId.error.empty", this.cmisFolderId));
        }
        if (this.spaceIds == null || ArrayUtils.isEmpty((Object[])this.spaceIds)) {
            this.addFieldError("spaceIds", this.getText("alfresco.for.confluence.admin.mapping-folder.space.error.empty"));
        }
        if (this.spaceIds != null) {
            List<Long> invalidProjectIds = this.getInvalidSpaceIds(this.spaceIds);
            if (!invalidProjectIds.isEmpty()) {
                this.addFieldError("spaceIds", this.getText("alfresco.for.confluence.admin.mapping-folder.space.error.invalid", invalidProjectIds));
            }
            if (!this.getSelectableSpaceIds(this.type).containsAll(Arrays.asList(this.spaceIds))) {
                this.addFieldError("spaceIds", this.getText("alfresco.for.confluence.admin.mapping-folder.space.error.duplicate", invalidProjectIds));
            }
        }
        if (this.hasErrors()) {
            return "error";
        }
        if (this.folderId != null) {
            this.mappingFolderService.updateFolder(this.folderId, this.name, this.cmisFolderId, Lists.newArrayList((Object[])this.spaceIds));
        } else {
            this.mappingFolderService.saveFolder(this.name, this.cmisFolderId, Lists.newArrayList((Object[])this.spaceIds), MappingFolderType.valueOf(this.type.toUpperCase()));
        }
        return "success";
    }

    public Integer getFolderId() {
        return this.folderId;
    }

    public void setFolderId(Integer folderId) {
        this.folderId = folderId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getCmisFolderId() {
        return this.cmisFolderId;
    }

    public void setCmisFolderId(String cmisFolderId) {
        this.cmisFolderId = cmisFolderId;
    }

    public Long[] getSpaceIds() {
        return this.spaceIds;
    }

    public void setSpaceIds(Long[] spaceIds) {
        this.spaceIds = spaceIds;
    }

    void doValidate() {
        if (this.folderId != null && this.mappingFolderService.getFolder(this.folderId) == null) {
            this.addActionError(this.getText("alfresco.for.confluence.admin.mapping-folder.folderId.error.removed", this.folderId.toString()));
        }
    }

    public List<Long> getInvalidSpaceIds(Long[] projectIds) {
        ArrayList<Long> invalidProjectIds = new ArrayList<Long>();
        for (Long projectId : projectIds) {
            if (this.spaceManager.getSpace(projectId.longValue()) != null) continue;
            invalidProjectIds.add(projectId);
        }
        return invalidProjectIds;
    }

    public List<Long> getSelectableSpaceIds(String type) {
        return Lists.transform(this.getSelectableSpaces(type), (Function)new Function<Space, Long>(){

            public Long apply(Space input) {
                return input.getId();
            }
        });
    }

    public List<Space> getSelectableSpaces(String type) {
        if (MappingFolderType.PRIVATE.name().equalsIgnoreCase(type)) {
            ArrayList<Space> selectableProjects = new ArrayList<Space>();
            List<Long> currentFolderUsedProjectIds = this.mappingFolderService.getSpaceIdsByFolderId(this.getFolderId());
            List<Long> allsFolderUsedProjectIds = this.mappingFolderService.getSpaceIds(MappingFolderType.valueOf(this.getType().toUpperCase()));
            for (Space space : this.spaceManager.getAllSpaces()) {
                if (!currentFolderUsedProjectIds.contains(space.getId()) && allsFolderUsedProjectIds.contains(space.getId())) continue;
                selectableProjects.add(space);
            }
            return selectableProjects;
        }
        return this.spaceManager.getAllSpaces();
    }

    public boolean isSelectedSpace(Long spaceId) {
        return ArrayUtils.contains((Object[])this.getSpaceIds(), (Object)spaceId);
    }

    @Override
    public String[] getSelectableType() {
        return MappingFolderType.getNames();
    }

    @Override
    public String getSelectableTypeName(String name) {
        return this.getText("alfresco.for.confluence.admin.mapping-folder.type." + name.toLowerCase());
    }
}

