/*
 * Decompiled with CFR 0.152.
 */
package jp.ricksoft.plugins.alfresco.admin;

import com.atlassian.xwork.RequireSecurityToken;
import com.google.common.collect.Lists;
import jp.ricksoft.plugins.alfresco.admin.CredentialAction;
import jp.ricksoft.plugins.alfresco.ao.entity.CredentialEntity;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class CredentialEditAction
extends CredentialAction {
    private static final long serialVersionUID = -1506738031835644741L;
    private static final Logger LOGGER = Logger.getLogger(CredentialEditAction.class);

    @RequireSecurityToken(value=true)
    public String doSave() {
        LOGGER.debug((Object)"doExecute() start");
        if (this.isInvalidLicense()) {
            return this.getInvalidLicenseRedirect();
        }
        this.doValidate();
        if (this.hasErrors()) {
            return "error";
        }
        CredentialEntity credential = this.credentialService.find();
        credential = credential != null ? this.credentialService.update(credential.getID(), this.alfrescoDisplayUrl, this.alfrescoApplicationUrl, this.shareDisplayUrl, this.authType, this.accessType, this.username, this.password, this.maximumLoginAttemptAllowed) : this.credentialService.save(this.alfrescoDisplayUrl, this.alfrescoApplicationUrl, this.shareDisplayUrl, this.authType, this.accessType, this.username, this.password, this.maximumLoginAttemptAllowed);
        return "success";
    }

    void doValidate() {
        if (StringUtils.isEmpty((CharSequence)this.alfrescoDisplayUrl)) {
            this.addFieldError("alfrescoDisplayUrl", this.getText("alfresco.for.confluence.admin.alfrescoDisplayUrl.error.empty", this.alfrescoDisplayUrl));
        }
        if (StringUtils.isEmpty((CharSequence)this.alfrescoApplicationUrl)) {
            this.addFieldError("alfrescoApplicationUrl", this.getText("alfresco.for.confluence.admin.alfrescoApplicationUrl.error.empty", this.alfrescoApplicationUrl));
        }
        if (StringUtils.isEmpty((CharSequence)this.authType)) {
            this.addFieldError("authType", this.getText("alfresco.for.confluence.admin.authType.error.empty", this.authType));
        }
        if (!this.getSelectableAuthType().containsKey(this.authType)) {
            this.addFieldError("authType", this.getText("alfresco.for.confluence.admin.authType.error.invalid", this.authType));
        }
        if (!this.getSelectableAccessType().containsKey(this.accessType)) {
            this.addFieldError("accessType", this.getText("alfresco.for.confluence.admin.accessType.error.invalid", this.accessType));
        }
        if (StringUtils.isEmpty((CharSequence)this.username)) {
            this.addFieldError("username", this.getText("alfresco.for.confluence.admin.username.error.empty", this.username));
        }
        if (StringUtils.isEmpty((CharSequence)this.password)) {
            this.addFieldError("password", this.getText("alfresco.for.confluence.admin.password.error.empty", this.password));
        }
        if (this.maximumLoginAttemptAllowed != null && (Integer.MAX_VALUE < this.maximumLoginAttemptAllowed || 1 > this.maximumLoginAttemptAllowed)) {
            this.addFieldError("maximumLoginAttemptAllowed", this.getText("alfresco.for.confluence.admin.maximumLoginAttemptAllowed.error.invalid", Lists.newArrayList((Object[])new Integer[]{this.maximumLoginAttemptAllowed, 1, Integer.MAX_VALUE})));
        }
    }
}

