/*
 * Copyright 2016 Ricksoft Co., Ltd.
 * All rights reserved.
 */
define('cmis/cmisremove', ['jquery', 'cmis/confluence-error-handler'], function($, errorHandler) {

  var DIALOG_ID = 'cmisremove-confirm-dialog';
  var DIALOG_SECTION = '<section role="dialog" id="'+DIALOG_ID+'" class="aui-layer aui-dialog2 aui-dialog2-small loadingInProgress" aria-hidden="true"></section>';
  var HIDDEN_CLASS = 'hidden';
  var LOADING_CLASS = "loading-documents";
  
  /**
   * ファイル/フォルダ削除を行う
   * @param {CmisDocument/CmisFolder} obj
   * @param {string} url
   */
  var doRemove = function(obj) {
    var d = new $.Deferred;
    
    if ($('#'+DIALOG_ID).length <= 0) {
      $('body').append(DIALOG_SECTION);
    }
    
    var options = {};
    if (obj.baseTypeId == "cmis:folder") {
      options = {
        param: {
          name: obj ? (obj.formatter && typeof obj.formatter === 'function') ? obj.formatter(obj).label : obj.name : null,
          title: AJS.I18n.getText('alfresco.for.confluence.page.folder.label')
        },
        xhr: function() { return obj.deleteTree(true); }
      };
    } else if (obj.baseTypeId == "cmis:document") {
      options = {
        param: {
          name: obj.name,
          title: AJS.I18n.getText('alfresco.for.confluence.page.file.label')
        },
        xhr: function() { return obj.remove(true); }
      };
    } else {
      // TODO unknown type
    } 

    var template = $(JIRA.Templates.cmisremove.confirm(options.param)),
        el = $("#"+DIALOG_ID).empty().append(template),
        dlg = AJS.dialog2("#"+DIALOG_ID);
    
    $("." + LOADING_CLASS, template).removeClass(HIDDEN_CLASS);
    
    el.find(".remove").click(function() {
      $("." + LOADING_CLASS, template).removeClass(HIDDEN_CLASS);
      options.xhr().done(function(data) {
        dlg.hide();
        d.resolve(data);
      }).fail(function(error) {
        errorHandler.showError($(".messages", "#"+DIALOG_ID), { body: AJS.I18n.getText('alfresco.for.confluence.ajax.error.remove'), error: error });
        d.reject();
      }).always(function() {
        $("." + LOADING_CLASS, template).addClass(HIDDEN_CLASS);
      });
    });
    el.find(".cancel").click(function() {
      d.reject();
      dlg.hide();
    });
    
    $("." + LOADING_CLASS, template).addClass(HIDDEN_CLASS);
    
    dlg.show();
    
    return d.promise();
  }

  return {
    doRemove: doRemove,
  }
});
