/*
 * Copyright 2016 Ricksoft Co., Ltd.
 * All rights reserved.
 */
define('cmis/cmisproperty', ['jquery', 'misc/Size', 'cmis/cmisconfluence', 'cmis/cmisproperty-helper', 'cmis/confluence-error-handler', 'attachments/attachment-permission' ], function ($, miscSize, cmisConfluence, cmisPropertyHelper, errorHandler, attachmentPermission) {

  var DIALOG_ID = 'cmisproperty-dialog';
  var DIALOG_SECTION = '<section role="dialog" id="' + DIALOG_ID + '" class="aui-layer aui-dialog2 aui-dialog2-medium loadingInProgress" aria-hidden="true"></section>';
  var HIDDEN_CLASS = 'hidden';
  var LOADING_CLASS = "loading-documents";
  /**
   * プロパティー表示・編集を行う
   * @param {CmisListView} invoker
   * @param {CmisDocument} doc
   * @param {string} dateformat
   */
  var doProperty = function (invoker, doc, dateformat) {

    if ($('#' + DIALOG_ID).length <= 0) {
      $('body').append(DIALOG_SECTION);
    }

    var ajsDlg = AJS.dialog2("#" + DIALOG_ID);

    render($("#" + DIALOG_ID), invoker, doc, dateformat);

    ajsDlg.show();

  }

  /**
   *
   * @param context
   * @param invoker
   * @param doc
   * @param dateformat
   */
  function render(context, invoker, doc, dateformat) {
    var dialogMethod = cmisConfluence.isGreaterThanOrEqualTo(AJS.version, "9.0") ? 'propertyDialog2' : 'propertyDialog';
    var template = $(JIRA.Templates.cmisproperty[dialogMethod]({
      'cmisConfluence': cmisConfluence,
      'filename': doc.name,
      'version': doc.versionLabel
    }));
    context.empty().append(template);

    var cmisSession = doc.session;

    (function () {

      $("." + LOADING_CLASS, template).removeClass(HIDDEN_CLASS);

      var d = new AJS.$.Deferred;

      var tasks = [];

      $.each(doc.secondaryObjectTypeIds.concat([doc.baseTypeId]), function (i, secondaryObjectTypeId) {
        tasks.push(cmisSession.getTypeDefinition(secondaryObjectTypeId));
      });

      $.when.apply(this, tasks).done(function () {
        d.resolve(arguments);
      }).fail(function (error) {
        errorHandler.showError($(".messages", "#"+DIALOG_ID), {
          body: AJS.I18n.getText('alfresco.for.confluence.ajax.error.property.definition'),
          error: error
        });
        d.reject();
      });

      return d.promise();

    })().pipe(function (propertyDefinitions) {

      return renderProperty("View", context, invoker, template, doc, dateformat, propertyDefinitions);

    }).always(function () {

      $("." + LOADING_CLASS, template).addClass(HIDDEN_CLASS);

    });

  }

  /**
   * @param type
   * @param context
   * @param invoker
   * @param template
   * @param doc
   * @param dateformat
   * @param propertyDefinitions
   * @param {Deferred}
   */
  function renderProperty(type, context, invoker, template, doc, dateformat, propertyDefinitions) {

    var d = new AJS.$.Deferred;

    var template_frame = $(JIRA.Templates.cmisproperty.propertyFrame());
    context.find(".cmis-property-frame").remove();
    context.find(".aui-dialog2-content").append(template_frame);

    var template_footer = $(JIRA.Templates.cmisproperty["propertyFooter" + type]());
    $(".aui-dialog2-footer", context).empty().append(template_footer);

    var cmisSession = doc.session;

    (function () {

      var d = new AJS.$.Deferred;

      cmisSession.getProperties(doc.id).done(function (properties) {
        d.resolve(propertyDefinitions, properties);
      }).fail(function (error) {
        errorHandler.showError($(".messages", "#"+DIALOG_ID), {
          body: AJS.I18n.getText('alfresco.for.confluence.ajax.error.property.render'),
          error: error
        });
        d.reject();
      });

      return d.promise();

    })().pipe(function (propertyDefinitions, properties) {

      $.each(cmisPropertyHelper.getRenderItems(properties, propertyDefinitions), function(index, renderItem){

        var propertyKey = renderItem.propertyKey;
        var propertyValue = renderItem.propertyValue || "";
        var propertyDefinition = renderItem.propertyDefinition;
        var propertyRenderDefinition = renderItem.propertyRenderDefinition;
        var propertyEditable = cmisPropertyHelper.isPropertyEditable(propertyDefinition, propertyRenderDefinition);
        var template_property = $(JIRA.Templates.cmisproperty["property" + type]({
          doc: doc,
          propertyKey: propertyKey,
          propertyValue: cmisPropertyHelper.formatPropertyValue(propertyKey, propertyValue, propertyDefinition),
          propertyDefinition: propertyDefinition,
          propertyRenderDefinition: propertyRenderDefinition,
          propertyEditable: propertyEditable
        }));

        $(".cmis-property", template).append(template_property);

      });

      $('.datetimepicker', template).datetimepicker({
        // format: cmisPropertyHelper.DEFAULT_DATETIME_FORMAT
      });

      $(".cmis-property", template).removeClass(HIDDEN_CLASS);
      $(".folder-info", template).removeClass(HIDDEN_CLASS);

      d.resolve();

    }, function (error) {

      errorHandler.showError($(".messages", "#" + DIALOG_ID), {
        body: AJS.I18n.getText('alfresco.for.confluence.ajax.error.property.render'),
        error: error
      });

      d.reject();

    });

    $("#dialog-edit-button", context).click(function (e) {

      e.preventDefault();

      $(".messages", "#" + DIALOG_ID).empty()

      renderProperty("Edit", context, invoker, template, doc, dateformat, propertyDefinitions);

    });
    $("#dialog-cancel-button", context).click(function (e) {

      e.preventDefault();

      $(".messages", "#" + DIALOG_ID).empty()

      renderProperty("View", context, invoker, template, doc, dateformat, propertyDefinitions);

    });
    $("#dialog-submit-button", context).click(function (e) {

      e.preventDefault();

      var updateProperties = {};

      if (!populateProperties(updateProperties, context, propertyDefinitions)) {
        return false;
      }

      cmisSession.updateProperties(doc.id, updateProperties).done(function(data) {
        AJS.messages.success($(".messages", "#" + DIALOG_ID).empty(), {
          title: AJS.I18n.getText('alfresco.for.confluence.property.success'),
          body: AJS.I18n.getText('alfresco.for.confluence.property.success.edit')
        });
        cmisConfluence.getDocumentById(doc.id).done(function(doc) {
          if (invoker._renderDocument) { invoker._renderDocument(doc); }
        });
        renderProperty("View", context, invoker, template, doc, dateformat, propertyDefinitions);
      }).fail(function(error) {
        errorHandler.showError($(".messages", "#" + DIALOG_ID).empty(), {
          body: AJS.I18n.getText('alfresco.for.confluence.ajax.error.property.render'),
          error: error
        });
      });

    });

    return d.promise();

  }

  /**
   * @param updateProperties
   * @param context
   * @param propertyDefinitions
   * @returns {{}}
   */
  function populateProperties(updateProperties, context, propertyDefinitions) {

    $("div[data-field].error", context).empty();

    $("textarea, input:text[property-type='decimal'], input:text[property-type='integer']", context).each(function(){
      if (!this.value) { return true; }
      updateProperties[this.name] = this.value;
    });

    $("input:text[property-type='datetime']", context).each(function(){
      if (!this.value) { return true; }
      updateProperties[this.name] = moment(this.value).valueOf();
    });

    $("input:checkbox[property-type='boolean']", context).each(function(){
      updateProperties[this.name] = $(this).prop('checked');
    });

    $("*[required]", context).each(function(){
      if($(this).val() == ""){
        getError(this).append(AJS.I18n.getText('alfresco.for.confluence.property.error.required', getLabel(this)));
      }
    });

    $("input[property-type='decimal'], input[property-type='integer']", context).each(function(){
      if($(this).val() && !$.isNumeric($(this).val())) {
        getError(this).append(AJS.I18n.getText('alfresco.for.confluence.property.error.number', getLabel(this)));
      }
    });

    $("input[property-type='integer']", context).each(function(){
      var propertyKey = $(this).attr('name');
      var propertyDefinition = cmisPropertyHelper.getPropertyDefinition(propertyKey, propertyDefinitions);
      // 通常はminValue: -2147483648, maxValue:2147483647となる...
      if($(this).val() && ($(this).val() < propertyDefinition.minValue || $(this).val() > propertyDefinition.maxValue)) {
        getError(this).append(AJS.I18n.getText('alfresco.for.confluence.property.error.number.range', getLabel(this), propertyDefinition.minValue, propertyDefinition.maxValue));
      }
    });

    $("input[property-type='datetime']", context).each(function(){
      if ($(this).val() && !$(this).val().match(/(\d{4})\/(\d{2})\/(\d{2}) (\d{2}):(\d{2})/)) {
        getError(this).append(AJS.I18n.getText('alfresco.for.confluence.property.error.datetime', getLabel(this), cmisPropertyHelper.DEFAULT_DATETIME_FORMAT));
      }
    });

    return $("div[data-field].error", context).contents().length == 0;

    function getLabel(self) {
      return $("label[for='" + $(self).attr("id") + "']", context).text();
    }

    function getError(self) {
      return $("div[data-field='" + $(self).attr("id") + "'].error", context);
    }

    function isBoolean(value) {
      return typeof value === 'boolean' || (typeof value === 'object' && typeof value.valueOf() === 'boolean');
    }

  }

  return {
    doProperty: doProperty,
  }
});
