/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.client.osgi;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import org.apache.chemistry.opencmis.client.api.SessionFactory;
import org.apache.chemistry.opencmis.client.runtime.SessionFactoryImpl;
import org.apache.chemistry.opencmis.commons.impl.ClassLoaderUtil;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.SynchronousBundleListener;
import org.osgi.framework.wiring.BundleWiring;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Activator
implements BundleActivator,
SynchronousBundleListener {
    private static final String OPENCMIS_SPI_HEADER = "OpenCMIS-SPI";
    private static Logger LOG = LoggerFactory.getLogger(Activator.class);
    private BundleContext bundleContext;

    public void start(BundleContext context) {
        this.bundleContext = context;
        context.addBundleListener((BundleListener)this);
        try {
            for (Bundle bundle : context.getBundles()) {
                if (bundle.getState() != 4 && bundle.getState() != 8 && bundle.getState() != 32 && bundle.getState() != 16) continue;
                this.register(bundle);
            }
        }
        catch (Exception e) {
            LOG.warn("Could not find and register bundles that contain OpenCMIS-SPI headers: ", (Object)e.toString(), (Object)e);
        }
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("service.description", "Apache Chemistry OpenCMIS Client Session Factory");
        ((Dictionary)props).put("service.vendor", "Apache Software Foundation");
        SessionFactoryImpl sessionFactory = SessionFactoryImpl.newInstance();
        context.registerService(SessionFactory.class.getName(), (Object)sessionFactory, props);
    }

    public void stop(BundleContext context) {
        context.removeBundleListener((BundleListener)this);
        this.bundleContext = null;
        ClassLoaderUtil.unregisterAllBundleClassLoaders();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bundleChanged(BundleEvent event) {
        Activator activator = this;
        synchronized (activator) {
            if (this.bundleContext == null) {
                return;
            }
        }
        if (event.getType() == 32) {
            this.register(event.getBundle());
        } else if (event.getType() == 64 || event.getType() == 16) {
            this.unregister(event.getBundle().getBundleId());
        }
    }

    private void register(Bundle bundle) {
        BundleWiring bundleWiring = (BundleWiring)bundle.adapt(BundleWiring.class);
        if (bundleWiring == null) {
            return;
        }
        ClassLoader classLoader = bundleWiring.getClassLoader();
        if (classLoader == null) {
            return;
        }
        List<String> classes = this.getOpenCmisSpiHeader(bundle);
        if (classes != null) {
            ClassLoaderUtil.registerBundleClassLoader(bundle.getBundleId(), classLoader, classes);
        }
    }

    private void unregister(long bundleId) {
        ClassLoaderUtil.unregisterBundleClassLoader(bundleId);
    }

    private List<String> getOpenCmisSpiHeader(Bundle bundle) {
        String[] split;
        String spiHeader = (String)bundle.getHeaders().get(OPENCMIS_SPI_HEADER);
        if (spiHeader == null) {
            return null;
        }
        ArrayList<String> headerValues = new ArrayList<String>();
        for (String className : split = spiHeader.split(",")) {
            if (className == null || className.trim().isEmpty()) continue;
            headerValues.add(className.trim());
        }
        return headerValues;
    }
}

