/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.client.bindings.spi.local;

import java.math.BigInteger;
import java.util.List;
import org.apache.chemistry.opencmis.client.bindings.spi.BindingSession;
import org.apache.chemistry.opencmis.client.bindings.spi.local.AbstractLocalService;
import org.apache.chemistry.opencmis.commons.data.ExtensionsData;
import org.apache.chemistry.opencmis.commons.data.RepositoryInfo;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinitionContainer;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinitionList;
import org.apache.chemistry.opencmis.commons.server.CmisService;
import org.apache.chemistry.opencmis.commons.server.CmisServiceFactory;
import org.apache.chemistry.opencmis.commons.spi.RepositoryService;

public class RepositoryServiceImpl
extends AbstractLocalService
implements RepositoryService {
    public RepositoryServiceImpl(BindingSession session, CmisServiceFactory factory) {
        this.setSession(session);
        this.setServiceFactory(factory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RepositoryInfo getRepositoryInfo(String repositoryId, ExtensionsData extension) {
        try (CmisService service = this.getService(repositoryId);){
            if (this.stopBeforeService(service)) {
                RepositoryInfo repositoryInfo = null;
                return repositoryInfo;
            }
            RepositoryInfo serviceResult = service.getRepositoryInfo(repositoryId, extension);
            if (this.stopAfterService(service)) {
                RepositoryInfo repositoryInfo = null;
                return repositoryInfo;
            }
            RepositoryInfo repositoryInfo = serviceResult;
            return repositoryInfo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<RepositoryInfo> getRepositoryInfos(ExtensionsData extension) {
        try (CmisService service = this.getService(null);){
            if (this.stopBeforeService(service)) {
                List<RepositoryInfo> list = null;
                return list;
            }
            List<RepositoryInfo> serviceResult = service.getRepositoryInfos(extension);
            if (this.stopAfterService(service)) {
                List<RepositoryInfo> list = null;
                return list;
            }
            List<RepositoryInfo> list = serviceResult;
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TypeDefinition getTypeDefinition(String repositoryId, String typeId, ExtensionsData extension) {
        try (CmisService service = this.getService(repositoryId);){
            if (this.stopBeforeService(service)) {
                TypeDefinition typeDefinition = null;
                return typeDefinition;
            }
            TypeDefinition serviceResult = service.getTypeDefinition(repositoryId, typeId, extension);
            if (this.stopAfterService(service)) {
                TypeDefinition typeDefinition = null;
                return typeDefinition;
            }
            TypeDefinition typeDefinition = serviceResult;
            return typeDefinition;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TypeDefinitionList getTypeChildren(String repositoryId, String typeId, Boolean includePropertyDefinitions, BigInteger maxItems, BigInteger skipCount, ExtensionsData extension) {
        try (CmisService service = this.getService(repositoryId);){
            if (this.stopBeforeService(service)) {
                TypeDefinitionList typeDefinitionList = null;
                return typeDefinitionList;
            }
            TypeDefinitionList serviceResult = service.getTypeChildren(repositoryId, typeId, includePropertyDefinitions, maxItems, skipCount, extension);
            if (this.stopAfterService(service)) {
                TypeDefinitionList typeDefinitionList = null;
                return typeDefinitionList;
            }
            TypeDefinitionList typeDefinitionList = serviceResult;
            return typeDefinitionList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<TypeDefinitionContainer> getTypeDescendants(String repositoryId, String typeId, BigInteger depth, Boolean includePropertyDefinitions, ExtensionsData extension) {
        try (CmisService service = this.getService(repositoryId);){
            if (this.stopBeforeService(service)) {
                List<TypeDefinitionContainer> list = null;
                return list;
            }
            List<TypeDefinitionContainer> serviceResult = service.getTypeDescendants(repositoryId, typeId, depth, includePropertyDefinitions, extension);
            if (this.stopAfterService(service)) {
                List<TypeDefinitionContainer> list = null;
                return list;
            }
            List<TypeDefinitionContainer> list = serviceResult;
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TypeDefinition createType(String repositoryId, TypeDefinition type, ExtensionsData extension) {
        try (CmisService service = this.getService(repositoryId);){
            if (this.stopBeforeService(service)) {
                TypeDefinition typeDefinition = null;
                return typeDefinition;
            }
            TypeDefinition serviceResult = service.createType(repositoryId, type, extension);
            if (this.stopAfterService(service)) {
                TypeDefinition typeDefinition = null;
                return typeDefinition;
            }
            TypeDefinition typeDefinition = serviceResult;
            return typeDefinition;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TypeDefinition updateType(String repositoryId, TypeDefinition type, ExtensionsData extension) {
        try (CmisService service = this.getService(repositoryId);){
            if (this.stopBeforeService(service)) {
                TypeDefinition typeDefinition = null;
                return typeDefinition;
            }
            TypeDefinition serviceResult = service.updateType(repositoryId, type, extension);
            if (this.stopAfterService(service)) {
                TypeDefinition typeDefinition = null;
                return typeDefinition;
            }
            TypeDefinition typeDefinition = serviceResult;
            return typeDefinition;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteType(String repositoryId, String typeId, ExtensionsData extension) {
        try (CmisService service = this.getService(repositoryId);){
            if (this.stopBeforeService(service)) {
                return;
            }
            service.deleteType(repositoryId, typeId, extension);
            if (this.stopAfterService(service)) {
                return;
            }
        }
    }
}

