/*
 * Decompiled with CFR 0.152.
 */
package jp.ricksoft.plugins.alfresco.upgrade;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.sal.api.message.Message;
import com.atlassian.sal.api.transaction.TransactionCallback;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.sal.api.upgrade.PluginUpgradeTask;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import jp.ricksoft.plugins.alfresco.ao.entity.DocumentLinkEntity;
import net.java.ao.Query;
import net.java.ao.RawEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpgradeTask_Build1
implements PluginUpgradeTask {
    private static final Logger logger = LoggerFactory.getLogger(UpgradeTask_Build1.class);
    private final ActiveObjects ao;
    private final TransactionTemplate transactionTemplate;
    private final PageManager pageManager;

    public UpgradeTask_Build1(ActiveObjects ao, TransactionTemplate transactionTemplate, PageManager pageManager) {
        this.ao = ao;
        this.transactionTemplate = transactionTemplate;
        this.pageManager = pageManager;
    }

    public String getPluginKey() {
        return "jp.ricksoft.plugins.alfresco-for-confluence";
    }

    public int getBuildNumber() {
        return 1;
    }

    public String getShortDescription() {
        return "Upgrade task for Update the newly added 'SPACE_ID' column of the 'AO_B64EA1_DOCUMENT_LINK_ENTITY' table.";
    }

    public Collection<Message> doUpgrade() throws Exception {
        return (Collection)this.transactionTemplate.execute((TransactionCallback)new TransactionCallback<Collection<Message>>(){

            public Collection<Message> doInTransaction() {
                ArrayList<DocumentLinkEntity> orphanEntities = new ArrayList<DocumentLinkEntity>();
                DocumentLinkEntity[] entities = (DocumentLinkEntity[])UpgradeTask_Build1.this.ao.find(DocumentLinkEntity.class, Query.select().where("SPACE_ID IS NULL", new Object[0]));
                if (entities == null | entities.length == 0) {
                    return Collections.emptyList();
                }
                for (DocumentLinkEntity entity : entities) {
                    Long pageId = entity.getPageId();
                    if (pageId == null) {
                        logger.debug("Orphan Entity has found by PageID. [" + entity.getID() + "]");
                        orphanEntities.add(entity);
                        continue;
                    }
                    AbstractPage page = UpgradeTask_Build1.this.pageManager.getAbstractPage(pageId.longValue());
                    if (page == null) {
                        logger.debug("Orphan Entity has found by Page. [" + entity.getID() + "]");
                        orphanEntities.add(entity);
                        continue;
                    }
                    Space space = page.getSpace();
                    if (space == null) {
                        logger.debug("Orphan Entity has found by Space. [" + entity.getID() + "]");
                        orphanEntities.add(entity);
                        continue;
                    }
                    Long spaceId = space.getId();
                    if (spaceId == null) {
                        logger.debug("Orphan Entity has found by SpaceID. [" + entity.getID() + "]");
                        orphanEntities.add(entity);
                        continue;
                    }
                    entity.setSpaceId(spaceId);
                    entity.save();
                    logger.debug("Entity's spaceId has updated. [" + entity.getID() + "][" + spaceId + "]");
                }
                for (DocumentLinkEntity orphanEntity : orphanEntities) {
                    UpgradeTask_Build1.this.ao.delete(new RawEntity[]{orphanEntity});
                    logger.debug("Orphan Entity has deleted. [" + orphanEntity.getID() + "]");
                }
                return Collections.emptyList();
            }
        });
    }
}

