/*
 * Decompiled with CFR 0.152.
 */
package jp.ricksoft.plugins.alfresco.rest.healthcheck;

import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.soy.renderer.SoyTemplateRenderer;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import jp.ricksoft.plugins.alfresco.ao.service.CredentialService;
import jp.ricksoft.plugins.alfresco.cmis.CmisOperation;
import jp.ricksoft.plugins.alfresco.rest.healthcheck.HealthCheckBaseURL;
import jp.ricksoft.plugins.alfresco.rest.healthcheck.HealthCheckBean;
import jp.ricksoft.plugins.alfresco.rest.healthcheck.HealthCheckItem;
import jp.ricksoft.plugins.alfresco.rest.healthcheck.HealthCheckMixedContent;
import jp.ricksoft.plugins.alfresco.rest.healthcheck.HealthCheckOrigin;
import jp.ricksoft.plugins.alfresco.rest.healthcheck.HealthCheckServerConnection;
import org.apache.log4j.Logger;

@Path(value="/healthcheck")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class HealthCheckResource {
    private static final Logger log = Logger.getLogger(HealthCheckResource.class);
    private final I18nResolver i18n;
    private final SoyTemplateRenderer soyRenderer;
    private final CredentialService credentialService;
    private final CmisOperation cmisOperation;

    public HealthCheckResource(I18nResolver i18n, SoyTemplateRenderer soyTemplateRenderer, CredentialService credentialService, CmisOperation cmisOperation) {
        this.i18n = i18n;
        this.soyRenderer = soyTemplateRenderer;
        this.credentialService = credentialService;
        this.cmisOperation = cmisOperation;
    }

    @GET
    public Response getHealthCheckInfo(@Context HttpServletRequest request) {
        ConfluenceUser loggedInUser = AuthenticatedUserThreadLocal.get();
        HealthCheckItem[] checkItems = new HealthCheckItem[]{new HealthCheckBaseURL(this.i18n, this.soyRenderer), new HealthCheckOrigin(this.i18n, this.soyRenderer, this.credentialService), new HealthCheckMixedContent(this.i18n, this.soyRenderer, this.credentialService), new HealthCheckServerConnection(this.i18n, this.soyRenderer, this.cmisOperation)};
        ArrayList<HealthCheckBean> results = new ArrayList<HealthCheckBean>();
        for (HealthCheckItem item : checkItems) {
            HealthCheckBean result = item.check(request, loggedInUser);
            if (result == null) continue;
            results.add(result);
        }
        return Response.ok(results).build();
    }
}

