/*
 * Decompiled with CFR 0.152.
 */
package jp.ricksoft.plugins.alfresco.listener;

import com.atlassian.confluence.event.events.space.SpaceCreateEvent;
import com.atlassian.confluence.event.events.space.SpaceRemoveEvent;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import jp.ricksoft.plugins.alfresco.ao.service.SpaceConfigService;
import jp.ricksoft.plugins.alfresco.permission.FeaturePermissionManager;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public class SpaceEventListener
implements InitializingBean,
DisposableBean {
    private static final Logger log = Logger.getLogger(SpaceEventListener.class);
    private final EventPublisher eventPublisher;
    private final FeaturePermissionManager featurePermissionManager;
    private final SpaceConfigService spaceConfigService;

    public SpaceEventListener(EventPublisher eventPublisher, FeaturePermissionManager featurePermissionManager, SpaceConfigService spaceConfigService) {
        this.eventPublisher = eventPublisher;
        this.featurePermissionManager = featurePermissionManager;
        this.spaceConfigService = spaceConfigService;
    }

    public void afterPropertiesSet() throws Exception {
        this.eventPublisher.register((Object)this);
    }

    public void destroy() throws Exception {
        this.eventPublisher.unregister((Object)this);
    }

    @EventListener
    public void onSpaceCreateEvent(SpaceCreateEvent event) {
        Space space = event.getSpace();
        this.featurePermissionManager.copyDefaultPermission(space);
    }

    @EventListener
    public void onSpaceRemoveEvent(SpaceRemoveEvent event) {
        Space space = event.getSpace();
        this.spaceConfigService.delete(space.getId());
        this.featurePermissionManager.clearAllPermissions(space);
    }
}

