/*
 * Decompiled with CFR 0.152.
 */
package jp.ricksoft.plugins.alfresco.cmis;

import com.atlassian.confluence.user.ConfluenceUser;
import com.google.common.base.Strings;
import java.util.HashMap;
import jp.ricksoft.plugins.alfresco.ao.service.CredentialSecretService;
import jp.ricksoft.plugins.alfresco.ao.service.CredentialService;
import jp.ricksoft.plugins.alfresco.auth.InvalidTokenException;
import jp.ricksoft.plugins.alfresco.auth.LoginAttemptsException;
import jp.ricksoft.plugins.alfresco.cmis.BaseCmisSession;
import jp.ricksoft.plugins.alfresco.cmis.CmisOperation;
import org.apache.chemistry.opencmis.client.api.FileableCmisObject;
import org.apache.chemistry.opencmis.client.api.Folder;
import org.apache.chemistry.opencmis.client.api.ItemIterable;
import org.apache.chemistry.opencmis.client.api.ObjectId;
import org.apache.chemistry.opencmis.client.api.QueryResult;
import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.chemistry.opencmis.commons.exceptions.CmisObjectNotFoundException;

public class BaseCmisOperation
extends BaseCmisSession
implements CmisOperation {
    public BaseCmisOperation(CredentialService credentialService, CredentialSecretService credentialSecretService) {
        super(credentialService, credentialSecretService);
    }

    @Override
    public ItemIterable<QueryResult> findObjectId(ConfluenceUser user, String expression) throws InvalidTokenException, LoginAttemptsException {
        Session cmisSession = this.getCmisSession(user);
        boolean searchAllVersions = false;
        StringBuilder statement = new StringBuilder();
        statement.append("SELECT");
        statement.append(" d.* ");
        statement.append("FROM cmis:document AS d ");
        if (!Strings.isNullOrEmpty((String)expression)) {
            statement.append("WHERE");
            statement.append(" CONTAINS(d,'" + expression + "')");
        }
        return cmisSession.query(statement.toString(), searchAllVersions);
    }

    @Override
    public ItemIterable<QueryResult> findObjectIdsByKeyword(ConfluenceUser user, String inTreeQury, String keyword, Session cmisSession) throws InvalidTokenException, LoginAttemptsException {
        boolean searchAllVersions = false;
        StringBuilder statement = new StringBuilder();
        statement.append("SELECT");
        statement.append(" d.cmis:objectId");
        statement.append(",d.cmis:name");
        statement.append(",d.cmis:description");
        statement.append(" FROM cmis:document AS d");
        statement.append(" WHERE");
        statement.append(" (").append(inTreeQury).append(")");
        if (!Strings.isNullOrEmpty((String)keyword)) {
            String sanitaizedKeyword = this.getSanitaizedKeyword(keyword);
            statement.append(" AND");
            statement.append(" CONTAINS(d,'" + sanitaizedKeyword + " OR cmis:name:" + sanitaizedKeyword + "') ");
        }
        statement.append(" ORDER BY d.cmis:name");
        if (cmisSession == null) {
            cmisSession = this.getCmisSession(user);
        }
        return cmisSession.query(statement.toString(), searchAllVersions);
    }

    private String getSanitaizedKeyword(String keyword) {
        String sanitaizedKeyword = keyword.replaceAll("\"", "\\\\\\\\\"");
        return "\"" + sanitaizedKeyword + "\"";
    }

    @Override
    public FileableCmisObject moveFolder(ConfluenceUser user, String targetPath, String sourcePath, String destinationPath) throws InvalidTokenException, LoginAttemptsException {
        Session cmisSession = this.getCmisSession(user);
        if (!this.isExistFolder(user, targetPath)) {
            throw new IllegalArgumentException("Target Folder is not found. [targetPath:" + targetPath + "]");
        }
        if (!this.isExistFolder(user, sourcePath)) {
            throw new IllegalArgumentException("Source Folder is not found. [sourcePath:" + sourcePath + "]");
        }
        if (!this.isExistFolder(user, destinationPath)) {
            throw new IllegalArgumentException("Destination Folder is not found. [destinationPath:" + destinationPath + "]");
        }
        FileableCmisObject targetfolder = (FileableCmisObject)cmisSession.getObjectByPath(targetPath);
        FileableCmisObject sourcefolder = (FileableCmisObject)cmisSession.getObjectByPath(sourcePath);
        FileableCmisObject destinationfolder = (FileableCmisObject)cmisSession.getObjectByPath(destinationPath);
        return targetfolder.move(sourcefolder, destinationfolder);
    }

    @Override
    public ObjectId createFolder(ConfluenceUser user, String path, String name) throws InvalidTokenException, LoginAttemptsException {
        Session cmisSession = this.getCmisSession(user);
        if (this.isExistFolder(user, path + "/" + name)) {
            return null;
        }
        FileableCmisObject folder = (FileableCmisObject)cmisSession.getObjectByPath(path);
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("cmis:objectTypeId", "cmis:folder");
        properties.put("cmis:name", name);
        return cmisSession.createFolder(properties, folder);
    }

    @Override
    public boolean isExistFolder(ConfluenceUser user, String path) throws InvalidTokenException, LoginAttemptsException {
        try {
            return this.getCmisSession(user).getObjectByPath(path) instanceof Folder;
        }
        catch (CmisObjectNotFoundException e) {
            return false;
        }
    }
}

