/*
 * Decompiled with CFR 0.152.
 */
package jp.ricksoft.plugins.alfresco.ao.service;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.spring.container.ContainerManager;
import com.atlassian.user.EntityException;
import com.atlassian.user.GroupManager;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import jp.ricksoft.plugins.alfresco.ao.entity.FeaturePermission;
import jp.ricksoft.plugins.alfresco.ao.service.FeaturePermissionService;
import jp.ricksoft.plugins.alfresco.permission.PermissionKeys;
import net.java.ao.DBParam;
import net.java.ao.Query;
import net.java.ao.RawEntity;

public class FeaturePermissionServiceImpl
implements FeaturePermissionService {
    private final ActiveObjects ao;

    public FeaturePermissionServiceImpl(ActiveObjects ao) {
        this.ao = (ActiveObjects)Preconditions.checkNotNull((Object)ao);
    }

    @Override
    public boolean contains(Long spaceId, PermissionKeys permissionKeys, String actorType, String actorName) {
        String key = this.getNameToKey(actorType, actorName);
        if (key == null) {
            return false;
        }
        FeaturePermission[] entities = spaceId != null ? (FeaturePermission[])this.ao.find(FeaturePermission.class, Query.select().where("SPACE_ID = ? and FEATURE = ? and ACTOR_TYPE = ? and ACTOR_NAME = ?", new Object[]{spaceId, permissionKeys.name().toLowerCase(), actorType, key}).limit(1)) : (FeaturePermission[])this.ao.find(FeaturePermission.class, Query.select().where("SPACE_ID IS NULL and FEATURE = ? and ACTOR_TYPE = ? and ACTOR_NAME = ?", new Object[]{permissionKeys.name().toLowerCase(), actorType, key}).limit(1));
        return entities.length == 1;
    }

    @Override
    public FeaturePermissionService.SeachResult getSearchResult(Long spaceId, PermissionKeys permissionKeys) {
        return this.getSearchResult(spaceId, permissionKeys, true);
    }

    @Override
    public FeaturePermissionService.SeachResult getUnformattedSearchResult(Long spaceId, PermissionKeys permissionKeys) {
        return this.getSearchResult(spaceId, permissionKeys, false);
    }

    FeaturePermissionService.SeachResult getSearchResult(Long spaceId, PermissionKeys permissionKeys, boolean keyToName) {
        FeaturePermission[] entities = spaceId != null ? (FeaturePermission[])this.ao.find(FeaturePermission.class, Query.select().where("SPACE_ID = ? and FEATURE = ?", new Object[]{spaceId, permissionKeys.name().toLowerCase()})) : (FeaturePermission[])this.ao.find(FeaturePermission.class, Query.select().where("SPACE_ID IS NULL and FEATURE = ?", new Object[]{permissionKeys.name().toLowerCase()}));
        ArrayList users = Lists.newArrayList();
        ArrayList groups = Lists.newArrayList();
        for (FeaturePermission e : entities) {
            String name;
            String t = e.getActorType();
            String n = e.getActorName();
            String string = name = keyToName ? this.getKeyToName(t, n) : n;
            if (name == null) continue;
            if (t.equals("user")) {
                users.add(name);
                continue;
            }
            if (!t.equals("group")) continue;
            groups.add(name);
        }
        return new SearchResultImpl(users, groups);
    }

    @Override
    public void clear(Long spaceId, PermissionKeys permissionKeys) {
        FeaturePermission[] entities = spaceId != null ? (FeaturePermission[])this.ao.find(FeaturePermission.class, Query.select().where("SPACE_ID = ? and FEATURE = ?", new Object[]{spaceId, permissionKeys.name().toLowerCase()})) : (FeaturePermission[])this.ao.find(FeaturePermission.class, Query.select().where("SPACE_ID IS NULL and FEATURE = ?", new Object[]{permissionKeys.name().toLowerCase()}));
        this.ao.delete((RawEntity[])entities);
    }

    @Override
    public void add(Long spaceId, PermissionKeys permissionKeys, List<String> users, List<String> groups) {
        if (users != null) {
            this.addEntities(spaceId, permissionKeys, "user", users);
        }
        if (groups != null) {
            this.addEntities(spaceId, permissionKeys, "group", groups);
        }
    }

    private void addEntities(Long spaceId, PermissionKeys permissionKeys, String actorType, List<String> names) {
        for (String name : names) {
            String key = this.getNameToKey(actorType, name);
            if (key == null) continue;
            FeaturePermission e = (FeaturePermission)this.ao.create(FeaturePermission.class, new DBParam[0]);
            e.setSpaceId(spaceId);
            e.setFeature(permissionKeys.name().toLowerCase());
            e.setActorType(actorType);
            e.setActorName(key);
            e.save();
        }
    }

    public String getKeyToName(String actorType, String key) {
        if (actorType.equals("user")) {
            UserAccessor userAccessor = (UserAccessor)ContainerManager.getComponent((String)"userAccessor");
            ConfluenceUser user = userAccessor.getUserByKey(new UserKey(key));
            return user != null ? user.getName() : null;
        }
        if (actorType.equals("group")) {
            return this.validatedGroupName(key);
        }
        throw new IllegalArgumentException("actorType[" + actorType + "] is invalid.");
    }

    public String getNameToKey(String actorType, String name) {
        if (actorType.equals("user")) {
            UserAccessor userAccessor = (UserAccessor)ContainerManager.getComponent((String)"userAccessor");
            ConfluenceUser user = userAccessor.getUserByName(name);
            return user != null ? user.getKey().getStringValue() : null;
        }
        if (actorType.equals("group")) {
            return this.validatedGroupName(name);
        }
        throw new IllegalArgumentException("actorType[" + actorType + "] is invalid.");
    }

    private String validatedGroupName(String name) {
        GroupManager groupManager = (GroupManager)ContainerManager.getComponent((String)"groupManager");
        try {
            return groupManager.getGroup(name) == null ? null : name;
        }
        catch (EntityException e) {
            return null;
        }
    }

    public static class SearchResultImpl
    implements FeaturePermissionService.SeachResult {
        List<String> users;
        List<String> groups;

        public SearchResultImpl(List<String> users, List<String> groups) {
            this.users = users;
            this.groups = groups;
        }

        @Override
        public List<String> getUsers() {
            return this.users;
        }

        @Override
        public List<String> getGroups() {
            return this.groups;
        }
    }
}

