/*
 * Decompiled with CFR 0.152.
 */
package jp.ricksoft.plugins.alfresco.ao.service;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.fugue.Either;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import jp.ricksoft.plugins.alfresco.ao.entity.CredentialEntity;
import jp.ricksoft.plugins.alfresco.ao.entity.CredentialSecret;
import jp.ricksoft.plugins.alfresco.ao.service.CredentialSecretService;
import jp.ricksoft.plugins.alfresco.ao.service.CredentialService;
import jp.ricksoft.plugins.alfresco.ao.service.CredentialTokenProvider;
import jp.ricksoft.plugins.alfresco.auth.AuthUtils;
import jp.ricksoft.plugins.alfresco.auth.InvalidTokenException;
import jp.ricksoft.plugins.alfresco.auth.UsernameToken;
import net.java.ao.DBParam;
import net.java.ao.Query;
import net.java.ao.RawEntity;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class CredentialServiceImpl
implements CredentialService {
    private final ActiveObjects ao;
    private final CredentialSecretService credentialSecretService;
    private final PermissionManager permissionManager;

    public CredentialServiceImpl(ActiveObjects ao, CredentialSecretService credentialSecretService, PermissionManager permissionManager) {
        this.ao = ao;
        this.credentialSecretService = credentialSecretService;
        this.permissionManager = permissionManager;
    }

    @Override
    public CredentialEntity find(int id) {
        return (CredentialEntity)this.ao.get(CredentialEntity.class, (Object)id);
    }

    @Override
    public CredentialEntity find() {
        Collection<CredentialEntity> jobs = this.findAll();
        return jobs != null && !jobs.isEmpty() ? jobs.iterator().next() : null;
    }

    @Override
    public Collection<CredentialEntity> findAll() {
        return Arrays.asList(this.ao.find(CredentialEntity.class, Query.select().order("ID ASC")));
    }

    @Override
    public CredentialEntity save(String alfrescoDisplayUrl, String alfrescoApplicationUrl, String shareDisplayUrl, String authType, String accessType, String username, String password, Integer maximumLoginAttemptAllowed) {
        CredentialEntity entity = (CredentialEntity)this.ao.create(CredentialEntity.class, new DBParam[0]);
        entity.setAlfrescoDisplayUrl(alfrescoDisplayUrl);
        entity.setAlfrescoApplicationUrl(alfrescoApplicationUrl);
        entity.setShareDisplayUrl(shareDisplayUrl);
        entity.setAuthType(authType);
        entity.setAccessType(accessType);
        entity.setUsername(username);
        entity.setSecret(this.generateSecret(authType, username, password));
        entity.setMaximumLoginAttemptAllowed(maximumLoginAttemptAllowed);
        entity.save();
        return entity;
    }

    @Override
    public CredentialEntity update(int id, String alfrescoDisplayUrl, String alfrescoApplicationUrl, String shareDisplayUrl, String authType, String accessType, String username, String password, Integer maximumLoginAttemptAllowed) {
        CredentialEntity entity = this.find(id);
        if (entity == null) {
            return entity;
        }
        entity.setAlfrescoDisplayUrl(alfrescoDisplayUrl);
        entity.setAlfrescoApplicationUrl(alfrescoApplicationUrl);
        entity.setShareDisplayUrl(shareDisplayUrl);
        entity.setAuthType(authType);
        entity.setAccessType(accessType);
        entity.setUsername(username);
        entity.setSecret(this.generateSecret(authType, username, password));
        entity.setMaximumLoginAttemptAllowed(maximumLoginAttemptAllowed);
        entity.save();
        return entity;
    }

    @Override
    public void delete(int id) {
        CredentialEntity entity = (CredentialEntity)this.ao.get(CredentialEntity.class, (Object)id);
        if (entity == null) {
            return;
        }
        this.ao.delete(new RawEntity[]{entity});
    }

    @Override
    public boolean hasAccessType(String accessType) {
        if (!ArrayUtils.contains((Object[])new String[]{"WithAdminProfile", "WithOwnProfile"}, (Object)accessType)) {
            throw new IllegalArgumentException("Unsupported accessType is specified.[" + accessType + "]");
        }
        CredentialEntity credentialEntity = this.find();
        if (credentialEntity == null) {
            return false;
        }
        if (StringUtils.isEmpty((CharSequence)accessType)) {
            return false;
        }
        return credentialEntity.getAccessType().equals(accessType);
    }

    @Override
    public CredentialTokenProvider generateTokenProvider(ConfluenceUser user) throws InvalidTokenException {
        return this.generateTokenProvider(user, false);
    }

    @Override
    public CredentialTokenProvider generateTokenProvider(ConfluenceUser user, boolean admin) throws InvalidTokenException {
        CredentialSecret credentialSecret;
        CredentialEntity credentialEntity = this.find();
        if (credentialEntity == null) {
            return null;
        }
        String alfrescoApplicationUrl = credentialEntity.getAlfrescoApplicationUrl();
        String alfrescoDisplayUrl = credentialEntity.getAlfrescoDisplayUrl();
        String shareDisplayUrl = credentialEntity.getShareDisplayUrl();
        String accessType = credentialEntity.getAccessType();
        String authType = credentialEntity.getAuthType();
        Integer maximumLoginAttemptAllowed = credentialEntity.getMaximumLoginAttemptAllowed();
        String username = null;
        String secret = null;
        String token = null;
        Integer currentLoginFailedCount = null;
        Long lastFailedLoginMillis = null;
        Either credentialEither = null;
        if (StringUtils.isEmpty((CharSequence)accessType) || "WithAdminProfile".equals(accessType) || admin) {
            username = credentialEntity.getUsername();
            secret = credentialEntity.getSecret();
            currentLoginFailedCount = credentialEntity.getCurrentLoginFailedCount();
            lastFailedLoginMillis = credentialEntity.getLastFailedLoginMillis();
            credentialEither = Either.left((Object)credentialEntity);
        } else if ("WithOwnProfile".equals(accessType) && (credentialSecret = this.credentialSecretService.find(user)) != null) {
            username = credentialSecret.getUsername();
            secret = credentialSecret.getSecret();
            currentLoginFailedCount = credentialSecret.getCurrentLoginFailedCount();
            lastFailedLoginMillis = credentialSecret.getLastFailedLoginMillis();
            credentialEither = Either.right((Object)credentialSecret);
        }
        if (StringUtils.isEmpty((CharSequence)authType) || "Basic".equals(authType)) {
            token = !StringUtils.isEmpty((CharSequence)secret) ? "Basic " + secret.trim() : null;
        } else if ("WSSE".equals(authType)) {
            token = new UsernameToken(username, secret).generate();
        }
        return new CredentialTokenProvider(alfrescoDisplayUrl, alfrescoApplicationUrl, shareDisplayUrl, authType, accessType, username, token, maximumLoginAttemptAllowed, currentLoginFailedCount, lastFailedLoginMillis, (Either<CredentialEntity, CredentialSecret>)credentialEither);
    }

    public String generateSecret(String authType, String username, String password) {
        if ("Basic".equals(authType)) {
            return AuthUtils.encodeBase64(username + ":" + password).trim();
        }
        if ("WSSE".equals(authType)) {
            return AuthUtils.encodeMD4(password);
        }
        throw new IllegalArgumentException("The specified authType is not supported. [" + authType + "]");
    }

    @Override
    public boolean hasUserCredential(ConfluenceUser user) {
        return this.credentialSecretService.find(user) != null;
    }

    @Override
    public CredentialEntity updateCurrentLoginFailed(CredentialEntity credentialEntity) {
        if (credentialEntity == null) {
            return credentialEntity;
        }
        Integer totalLoginFailedCount = credentialEntity.getTotalLoginFailedCount();
        Integer currentLoginFailedCount = credentialEntity.getCurrentLoginFailedCount();
        credentialEntity.setTotalLoginFailedCount((totalLoginFailedCount != null ? totalLoginFailedCount : 0) + 1);
        credentialEntity.setCurrentLoginFailedCount((currentLoginFailedCount != null ? currentLoginFailedCount : 0) + 1);
        credentialEntity.setLastFailedLoginMillis(new Date().getTime());
        credentialEntity.save();
        return credentialEntity;
    }

    @Override
    public CredentialEntity resetFailedLoginCount(CredentialEntity credentialEntity) {
        if (credentialEntity == null) {
            return credentialEntity;
        }
        credentialEntity.setCurrentLoginFailedCount(0);
        credentialEntity.save();
        return credentialEntity;
    }
}

