/*
 * Decompiled with CFR 0.152.
 */
package jp.ricksoft.plugins.alfresco.admin;

import com.atlassian.xwork.RequireSecurityToken;
import jp.ricksoft.plugins.alfresco.admin.MappingFolderAction;
import jp.ricksoft.plugins.alfresco.ao.entity.MappingFolder;
import jp.ricksoft.plugins.alfresco.ao.entity.MappingFolderType;
import org.apache.log4j.Logger;

public class MappingFolderRemoveAction
extends MappingFolderAction {
    private static final long serialVersionUID = 2169745777527374397L;
    private static final Logger LOGGER = Logger.getLogger(MappingFolderRemoveAction.class);
    private Integer folderId;
    private String name;
    private String type = MappingFolderType.PUBLIC.name();
    private String cmisFolderId;
    private Long[] spaceIds;

    @Override
    @RequireSecurityToken(value=true)
    public String execute() {
        if (this.isInvalidLicense()) {
            return this.getInvalidLicenseRedirect();
        }
        this.doValidate();
        if (this.hasErrors()) {
            return "error";
        }
        MappingFolder folder = this.mappingFolderService.getFolder(this.folderId);
        this.setName(folder.getName());
        this.setType(folder.getType());
        this.setCmisFolderId(folder.getPath().getCmisFolderId());
        this.setSpaceIds(folder.getSpaceIds());
        return "success";
    }

    @RequireSecurityToken(value=true)
    public String doSave() {
        LOGGER.debug((Object)"doSave() start");
        if (this.isInvalidLicense()) {
            return this.getInvalidLicenseRedirect();
        }
        this.doValidate();
        if (this.hasErrors()) {
            return "error";
        }
        this.mappingFolderService.deleteFolder(this.folderId);
        return "success";
    }

    public Integer getFolderId() {
        return this.folderId;
    }

    public void setFolderId(Integer folderId) {
        this.folderId = folderId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getCmisFolderId() {
        return this.cmisFolderId;
    }

    public void setCmisFolderId(String cmisFolderId) {
        this.cmisFolderId = cmisFolderId;
    }

    public Long[] getSpaceIds() {
        return this.spaceIds;
    }

    public void setSpaceIds(Long[] spaceIds) {
        this.spaceIds = spaceIds;
    }

    void doValidate() {
        if (this.folderId == null) {
            this.addActionError(this.getText("alfresco.for.confluence.admin.mapping-folder.folderId.error.empty"));
        }
        if (this.folderId != null && this.mappingFolderService.getFolder(this.folderId) == null) {
            this.addActionError(this.getText("alfresco.for.confluence.admin.mapping-folder.folderId.error.removed", this.folderId.toString()));
        }
    }

    public String[] getSelectableTypes() {
        return MappingFolderType.getNames();
    }

    @Override
    public String getSelectableTypeName(String name) {
        return this.getText("alfresco.for.confluence.admin.mapping-folder.type." + name.toLowerCase());
    }
}

