/*
 * Copyright 2016 Ricksoft Co., Ltd.
 * All rights reserved.
 */
define('app/autocomplete-mapped-space', [
  'jquery',
  'ajs',
  'document'
], function(
  $,
  AJS,
  document
) {
  "use strict";

  function bind(scope) {
    scope = scope || document.body;
    var showNoResultsIfAllResultsDisabled = function() {
      var $results = $('.select2-drop-active > .select2-results');
      if ($results.children('.select2-result-selectable').length === 0 &&
        $results.children('.select2-disabled').length) {

        $results.append('<li class="select2-no-results">' +
          AJS.escapeHtml("") + '</li>');
      }
    };

    $("input.autocomplete-mapped-space", scope).each(function() {
      var picker = $(this);
      picker.attr('data-autocomplete-bound', 'true');
      var includeGroups = picker.attr('data-include-groups');

      picker.auiSelect2({
        multiple: false,
        minimumInputLength: 2,
        formatInputTooShort: function () {
          return  AJS.I18n.getText('alfresco.for.confluence.search.formatInputTooShort');
        },
        ajax: {
          transport: function(opts) {
            // Workaround for Select2 bug: https://github.com/ivaynberg/select2/issues/381
            // Select2 does not display "no results found" if the only results are already selected.
            var success = opts.success;
            delete opts.success;

            return $.ajax.apply($.ajax, arguments).done(success).done(showNoResultsIfAllResultsDisabled);
          },
          data: function (searchTerm) {
            return {
              "max-results": 6,
              query: searchTerm
            };
          },
          dataType: 'json',
          url: Confluence.getContextPath() + '/rest/alfresco/latest/picker/mappedspace',
          results: function (data) {
            var results = [];
            $.each(data.result, function () {
              results.push({
                id: this.spaceKey,
                text: this.name,
                entity: this
              });
            });
            return {
              results: results
            };
          },
          quietMillis: 300
        },
        // common.Widget.avatarWithName handles escaping so this doesn't have to
        escapeMarkup: function (markup) {
          return markup;
        },
        dropdownCssClass: 'mappedspace-dropdown',
        containerCssClass: 'mappedspace-autocomplete',
        hasAvatar: true
      });

      // Logged in user will appear by default if this attribute is defined
      if (!picker.data("autofill-user"))
        return;

      var loggedInUser = AJS.Meta.get('remote-user'),
        loggedInUserFullName = AJS.Meta.get('current-user-fullname'),
        loggedInUserAvatarUrl = AJS.Meta.get('current-user-avatar-uri-reference');

      if (loggedInUser && loggedInUserFullName && loggedInUserAvatarUrl) {
        picker.auiSelect2('data',
          [{id: loggedInUser, text: loggedInUserFullName, imgSrc: loggedInUserAvatarUrl}]
        );
      }
    });
  }
  return {
    bind: bind
  }
});
