/*
 * Copyright 2016 Ricksoft Co., Ltd.
 * All rights reserved.
 */
AJS.toInit(function() {

  var $ = AJS.$;

  var $dialog;

  require(['cmis/cmisconfluence', 'cmis/confluence-error-handler'], function(cmisConfluence, errorHanderl) {

    // Shows the dialog when the "Show dialog" button is clicked
    $("#connection-test[disabled!=disabled]").click(function() {
      AJS.dialog2("#connection-check-dialog").show();
    });
    $("#dialog-close-button").click(function() {
      if ($dialog) {
        AJS.dialog2("#connection-check-dialog").hide();
      }
    });
    AJS.dialog2("#connection-check-dialog").on("show", function() {
      $dialog = $('#connection-check-dialog');

      $('.aui-dialog2-content .results', $dialog).empty();

      $('.spinner', $dialog).removeClass("hidden");


      $.when(
        callClientHealthCheck(cmisConfluence)
      ).done(function(clientSideResult) {

        renderHealcheckResult(clientSideResult);

        $('.spinner', $dialog).addClass("hidden");
      });
    });

    AJS.dialog2("#connection-check-dialog").on("hide", function() {
      if (cmisConfluence.isLimitMaximumLoginAttemptAllowed() && cmisConfluence.isOverMaximumLoginAttemptAllowed()) {
        cmisConfluence.reloadPage();
      }
    });

  });

  /**
   * サーバーサイドで実施するチェック
   */
  function callServerHealthcheck() {
    var d = new $.Deferred;
    JIRA.SmartAjax.makeRequest({
      url: contextPath + "/rest/alfresco/1.0/healthcheck",
      complete: function (xhr, status, response) {
        if (response.successful) {
          d.resolve(response.data);
        } else {
          d.resolve([]);
        }

      }
    });
    return d.promise();
  }

  /**
   * クライアントサイドで実施するチェック
   * @param cmisConfluence
   */
  function callClientHealthCheck(cmisConfluence) {

    var d = new $.Deferred;

    var dummy = {
      isFederatable: function() { return true; }
    };

    var title = AJS.I18n.getText('alfresco.for.confluence.admin.healthcheck.clientconnection.title');

    cmisConfluence.initCmisSession(dummy).done(function() {

      // 最大ログイン試行回数を超えた場合はユーザーにログイン確認とリセットを促す
      if (cmisConfluence.isLimitMaximumLoginAttemptAllowed() && cmisConfluence.isOverMaximumLoginAttemptAllowed()) {
        // 認証エラー
        d.resolve({
          title:title,
          status:"ERROR",
          message: AJS.I18n.getText('alfresco.for.confluence.ajax.error.reset-failed-login-count', cmisConfluence.getUserProfilePanelUrl())
        });
      } else {
        d.resolve({
          title:title,
          status:"SUCCESS",
          message: AJS.I18n.getText('alfresco.for.confluence.admin.healthcheck.clientconnection.success.message')
        });
      }
    }).fail(function(error) {

      if (error.response.status == 401) {
        // 認証エラー
        d.resolve({
          title:title,
          status:"ERROR",
          message: AJS.I18n.getText('alfresco.for.confluence.admin.healthcheck.clientconnection.error.unauthorized.message', error.message),
          error: error
        });
      } else {
        // 認証エラー以外
        d.resolve({
          title:title,
          status:"ERROR",
          message: AJS.I18n.getText('alfresco.for.confluence.admin.healthcheck.clientconnection.error.notconnected.message', error.message),
          error: error
        });
      }
    });

    return d.promise();
  }

  function renderHealcheckResult(data) {

    if (!$.isArray(data)) {
      data = [data];
    }

    $.each(data, function(index, val) {
      var $template = $(Connector.Templates.credential.checkStatusItem(val));
      $('.aui-dialog2-content .results', $dialog).append($template);

      $template.find('.check-status-row').click({el:$template}, toggleExpand);
    });
  }

  function toggleExpand(e) {
    var $item = e.data.el;
    if ($item.hasClass('expanded')) {
      $item.removeClass('expanded');
    } else {
      $item.addClass('expanded');
    }
    e.preventDefault();
    return false;
  }

});
