/*
 * Copyright 2016 Ricksoft Co., Ltd.
 * All rights reserved.
 */
define('misc/Size', [], function() {'use strict';

  return {
	/**
	 * バイト数を読みやすい単位にフォーマットする
	 * @param {Integer} fileSizeInBytes バイト数
	 * @return {String} フォーマットされた文字列
	 */
    getReadableSizeString: function(fileSizeInBytes) {
      var i = -1;
  	  var byteUnits = [' KB', ' MB', ' GB', ' TB', 'PB', 'EB', 'ZB', 'YB'];
  	  do {
  	    fileSizeInBytes = fileSizeInBytes / 1024;
  	    i++;
  	  } while (fileSizeInBytes > 1024);

  	  return Math.max(fileSizeInBytes, 0.1).toFixed(1) + byteUnits[i];
    }
  };
  
});
