/*
 * Copyright 2016 Ricksoft Co., Ltd.
 * All rights reserved.
 */
define('misc/BlobUtil', ['jquery'], function($) {'use strict';

  return {

    /**
     * 文字列をArrayBufferに変換します
     * @param {String} str 変換対象文字列
     * @return Deferred
     */
    string2array: function(str) {
      var d = new $.Deferred,
          fr = new FileReader();
      fr.onload = function() {
        d.resolve(this.result);
      };
      fr.onerror = function() {
        d.reject(this.error);
      };
      
      fr.readAsArrayBuffer(new Blob([str]));
      
      return d.promise();
    },
    
    /**
     * BlobをArrayBufferに変換します
     * @param {Blob} blob 変換対象Blob
     * @return Deferred
     */
    blob2array: function(blob) {
      var d = new $.Deferred,
      fileReader = new FileReader();
      fileReader.onload = function() {
        d.resolve(this.result);
      };
      fileReader.onerror = function() {
        d.reject(this.error);
      };
      
      fileReader.readAsArrayBuffer(blob);
      
      return d.promise();
    },
    
    /**
     * ArrayBufferを連結します
     * @param {ArrayBuffer} buffer1
     * @param {ArrayBuffer} buffer2
     * @return {ArrayBuffer}
     */
    concatArray: function(buffer1, buffer2) {
      var tmp = new Uint8Array(buffer1.byteLength + buffer2.byteLength);
      tmp.set(new Uint8Array(buffer1), 0);
      tmp.set(new Uint8Array(buffer2), buffer1.byteLength);
      return tmp.buffer;
    },
    
    /**
     * 
     */
    binary2dataURISheme: function(binary, mimeType) {
      var d = new $.Deferred;
      var fileReader = new FileReader();
      fileReader.onload = function() {
          var bytes = new Uint8Array(this.result),
          binaryData = "";
          for (var i = 0, len = bytes.byteLength; i < len; i++) {
            binaryData += String.fromCharCode(bytes[i]);
          }
        var encodedContent = btoa(binaryData),
            dataURIScheme = "data:" + mimeType + ";base64," + encodedContent;

        d.resolve(dataURIScheme);
      };
      fileReader.readAsArrayBuffer(binary);
      return d.promise();
    }
  };
  
});
