/*
 * Copyright 2016 Ricksoft Co., Ltd.
 * All rights reserved.
 */
define('cmis/confluence-listview-helper', ['jquery', 'cmis/cmisconfluence'],
    function($, cmisConfluence) {
  
  function ConfluenceListViewHelper() {
  }
  
  ConfluenceListViewHelper.prototype.getDocumentByIds = function(ids) {
    return cmisConfluence.getDocumentByIds(ids);
  }

  ConfluenceListViewHelper.prototype.link = function(documents, pageId) {
    return cmisConfluence.addLinksByPage(documents, pageId);
  }

  ConfluenceListViewHelper.prototype.unlink = function(documents, pageId) {
    return cmisConfluence.removeLinksByPage(documents, pageId);
  }

  ConfluenceListViewHelper.prototype.links = function(document, pageIds) {
    return cmisConfluence.addLinksByObject(document, pageIds);
  }

  ConfluenceListViewHelper.prototype.unlinks = function(document, pageIds) {
    return cmisConfluence.removeLinksByObject(document, pageIds);
  }

  ConfluenceListViewHelper.prototype.addFavorite = function(documents) {
    return cmisConfluence.addFavorite(documents);
  }

  ConfluenceListViewHelper.prototype.delFavorite = function(documents) {
    return cmisConfluence.delFavorite(documents);
  }

  ConfluenceListViewHelper.prototype.getPreviewLink = function(doc) {
    return cmisConfluence.getPreviewLink(doc);
  }
  
  return {
    create: function() {
      return new ConfluenceListViewHelper();
    }
  };
});
