/*
 * Decompiled with CFR 0.152.
 */
package jp.ricksoft.plugins.alfresco.search;

import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.api.model.link.Link;
import com.atlassian.confluence.api.model.link.LinkType;
import com.atlassian.confluence.api.service.search.CQLSearchService;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.plugin.osgi.container.OsgiContainerManager;
import com.atlassian.spring.container.ContainerManager;
import com.atlassian.user.User;
import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import jp.ricksoft.plugins.alfresco.ao.entity.DocumentLinkEntity;
import jp.ricksoft.plugins.alfresco.ao.entity.MappingFolder;
import jp.ricksoft.plugins.alfresco.ao.service.DocumentLinkService;
import jp.ricksoft.plugins.alfresco.ao.service.MappingFolderService;
import jp.ricksoft.plugins.alfresco.auth.InvalidTokenException;
import jp.ricksoft.plugins.alfresco.auth.LoginAttemptsException;
import jp.ricksoft.plugins.alfresco.cmis.CmisOperation;
import jp.ricksoft.plugins.alfresco.rest.SearchResultItem;
import jp.ricksoft.plugins.alfresco.rest.SearchResultPage;
import jp.ricksoft.plugins.alfresco.rest.permission.FeaturePermissionResourceHelper;
import jp.ricksoft.plugins.alfresco.search.DocumentSearch;
import jp.ricksoft.plugins.alfresco.search.DocumentSearchResult;
import org.apache.chemistry.opencmis.client.api.ItemIterable;
import org.apache.chemistry.opencmis.client.api.QueryResult;
import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.log4j.Logger;

public class DocumentSearchImpl
implements DocumentSearch {
    private static final Logger log = Logger.getLogger(DocumentSearchImpl.class);
    private CQLSearchService searchService;
    private final MappingFolderService mappingFolderService;
    private final DocumentLinkService linkService;
    private PermissionManager permissionManager;
    private SpaceManager spaceManager;
    private final CmisOperation cmisOperation;
    private final FeaturePermissionResourceHelper featurePermissionResourceHelper;
    private final int maxNumber = 2000;
    private final int maxItemsPerPage = 10;

    @Override
    public int getMaxItemsPerPage() {
        return 10;
    }

    public DocumentSearchImpl(PermissionManager permissionManager, DocumentLinkService linkService, CmisOperation cmisOperation, SpaceManager spaceManager, MappingFolderService mappingFolderService, FeaturePermissionResourceHelper featurePermissionResourceHelper) {
        this.linkService = linkService;
        this.cmisOperation = cmisOperation;
        this.mappingFolderService = mappingFolderService;
        this.permissionManager = permissionManager;
        this.spaceManager = spaceManager;
        this.featurePermissionResourceHelper = featurePermissionResourceHelper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DocumentSearchResult search(ConfluenceUser user, Space space, String expression, int pageNumber) throws LoginAttemptsException {
        log.debug((Object)"=== DocumentSearchResult.search start");
        try {
            DocumentSearchResult documentSearchResult = new DocumentSearchResult();
            HashSet<String> folderIdSet = new HashSet<String>();
            long start = System.currentTimeMillis();
            log.debug((Object)"   --- mappingFolderService.streamAll start");
            if (!this.permissionManager.hasPermission((User)user, Permission.VIEW, (Object)space)) {
                DocumentSearchResult documentSearchResult2 = documentSearchResult;
                return documentSearchResult2;
            }
            if (!this.featurePermissionResourceHelper.canBrowsePanel(space, user)) {
                DocumentSearchResult documentSearchResult3 = documentSearchResult;
                return documentSearchResult3;
            }
            List<MappingFolder> mappingFolders = this.mappingFolderService.getFoldersBySpaceId(space.getId());
            for (MappingFolder mappingFolder : mappingFolders) {
                String folderId = mappingFolder.getPath().getCmisFolderId();
                folderIdSet.add(folderId);
            }
            StringBuilder sb = new StringBuilder();
            for (String folderId : folderIdSet) {
                sb.append("IN_TREE('" + folderId + "') OR ");
            }
            log.debug((Object)"   --- mappingFolderService.streamAll end");
            long l = System.currentTimeMillis();
            log.debug((Object)("   --- " + (l - start) + " ms -> " + (l - start) / 1000L + " s"));
            String inTreeQury = sb.toString();
            if (Strings.isNullOrEmpty((String)inTreeQury)) {
                DocumentSearchResult documentSearchResult2 = documentSearchResult;
                return documentSearchResult2;
            }
            inTreeQury = inTreeQury.substring(0, inTreeQury.length() - 3);
            Session cmisSession = this.cmisOperation.getCmisSession(user);
            start = System.currentTimeMillis();
            log.debug((Object)"   *** cmisOperation.findObjectIdsByKeyword start");
            ItemIterable<QueryResult> cmisResults = this.cmisOperation.findObjectIdsByKeyword(user, inTreeQury, expression, cmisSession);
            if (cmisResults == null) {
                DocumentSearchResult documentSearchResult6 = documentSearchResult;
                return documentSearchResult6;
            }
            documentSearchResult.setTotalNumber(cmisResults.getTotalNumItems());
            cmisResults = cmisResults.skipTo(this.maxItemsPerPage * pageNumber).getPage(this.maxItemsPerPage);
            log.debug((Object)"   *** cmisOperation.findObjectIdsByKeyword end");
            l = System.currentTimeMillis();
            log.debug((Object)("   *** " + (l - start) + " ms -> " + (l - start) / 1000L + " s"));
            start = System.currentTimeMillis();
            log.debug((Object)"   === setSearchResult start");
            documentSearchResult.setSearchResultItemList(this.getSearchResult((User)user, cmisResults));
            log.debug((Object)"   === setSearchResult end");
            l = System.currentTimeMillis();
            log.debug((Object)("   === " + (l - start) + " ms -> " + (l - start) / 1000L + " s"));
            DocumentSearchResult documentSearchResult3 = documentSearchResult;
            return documentSearchResult3;
        }
        catch (InvalidTokenException ite) {
            DocumentSearchResult documentSearchResult = null;
            return documentSearchResult;
        }
        finally {
            log.debug((Object)"=== DocumentSearchResult.search end");
        }
    }

    private List<SearchResultItem> getSearchResult(User user, ItemIterable<QueryResult> cmisResults) {
        ArrayList<SearchResultItem> resultItems = new ArrayList<SearchResultItem>();
        if (cmisResults == null) {
            return resultItems;
        }
        for (QueryResult queryResult : cmisResults) {
            String objectId = (String)queryResult.getPropertyValueById("cmis:objectId");
            String name = (String)queryResult.getPropertyValueById("cmis:name");
            String description = (String)queryResult.getPropertyValueById("cmis:description");
            ArrayList<SearchResultPage> resultPages = new ArrayList<SearchResultPage>();
            DocumentLinkEntity[] documentLinks = this.linkService.findByObjectId(this.linkService.convertObjectId(objectId));
            List<Content> pages = this.getPageResponse(documentLinks, user);
            if (pages != null) {
                for (Content page : pages) {
                    resultPages.add(new SearchResultPage(page.getId().asLong(), page.getTitle(), this.getPageURL(page), page.getType().getType()));
                }
            }
            resultItems.add(new SearchResultItem(objectId, name, description, resultPages));
        }
        return resultItems;
    }

    private List<Content> getPageResponse(DocumentLinkEntity[] documentLinks, User user) {
        if (documentLinks == null || documentLinks.length == 0) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (DocumentLinkEntity documentLink : documentLinks) {
            sb.append(documentLink.getPageId()).append(",");
        }
        String pageIds = sb.toString();
        pageIds = pageIds.substring(0, pageIds.length() - 1);
        List contents = this.getSearchService().searchContent("content in(" + pageIds + ")", new Expansion[0]).getResults();
        if (contents.isEmpty()) {
            return null;
        }
        return contents;
    }

    private String getPageURL(Content page) {
        for (Link link : page.getLinks().values()) {
            if (link.getType() == null || !LinkType.WEB_UI.getValue().equals(link.getType().getValue())) continue;
            return link.getPath();
        }
        return "";
    }

    public CQLSearchService getSearchService() {
        if (this.searchService == null) {
            OsgiContainerManager osgiContainerManager = (OsgiContainerManager)ContainerManager.getComponent((String)"osgiContainerManager");
            this.setSearchService((CQLSearchService)osgiContainerManager.getServiceTracker(CQLSearchService.class.getName()).getService());
        }
        return this.searchService;
    }

    public void setSearchService(CQLSearchService searchService) {
        this.searchService = searchService;
    }
}

