/*
 * Decompiled with CFR 0.152.
 */
package jp.ricksoft.plugins.alfresco.rest.picker;

import com.atlassian.confluence.search.actions.json.ContentNameMatch;
import com.atlassian.confluence.search.actions.json.ContentNameSearchResult;
import com.atlassian.confluence.search.contentnames.ContentNameSearchService;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import jp.ricksoft.plugins.alfresco.ao.entity.MappingFolder;
import jp.ricksoft.plugins.alfresco.ao.service.MappingFolderService;
import jp.ricksoft.plugins.alfresco.rest.permission.FeaturePermissionResourceHelper;
import jp.ricksoft.plugins.alfresco.rest.picker.MappedSpaceBean;
import jp.ricksoft.plugins.alfresco.rest.picker.MappedSpacesBean;
import org.apache.commons.lang.StringUtils;

@Path(value="/picker/mappedspace")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class MappedSpacePickerResource {
    private final Integer DEFAULT_MAX_RESULTS = 10;
    private final SpaceManager spaceManager;
    private final PermissionManager permissionManager;
    private final ContentNameSearchService contentNameSarchService;
    private final MappingFolderService mappingFolderService;
    private final FeaturePermissionResourceHelper featurePermissionResourceHelper;

    public MappedSpacePickerResource(SpaceManager spaceManager, PermissionManager permissionManager, ContentNameSearchService contentNameSarchService, MappingFolderService mappingFolderService, FeaturePermissionResourceHelper featurePermissionResourceHelper) {
        this.spaceManager = spaceManager;
        this.permissionManager = permissionManager;
        this.contentNameSarchService = contentNameSarchService;
        this.mappingFolderService = mappingFolderService;
        this.featurePermissionResourceHelper = featurePermissionResourceHelper;
    }

    @GET
    public Response findMappedSpaces(@Context HttpServletRequest httpServletRequest, @QueryParam(value="query") String query, @QueryParam(value="max-results") Integer maxResults) {
        ConfluenceUser loggedInUser = AuthenticatedUserThreadLocal.get();
        if (maxResults == null || maxResults <= 0) {
            maxResults = this.DEFAULT_MAX_RESULTS;
        }
        List<Space> spaces = StringUtils.isBlank((String)query) ? this.findAllSpace(loggedInUser, maxResults) : this.findSpace(httpServletRequest, loggedInUser, query, maxResults);
        ArrayList result = Lists.newArrayList();
        for (Space space : spaces) {
            result.add(new MappedSpaceBean(space.getId(), space.getKey(), space.getName()));
        }
        return Response.ok((Object)new MappedSpacesBean(result)).build();
    }

    private List<Space> findSpace(HttpServletRequest httpServletRequest, ConfluenceUser loggedInUser, String query, Integer maxResults) {
        ContentNameSearchResult searchResult = this.contentNameSarchService.search(query, Arrays.asList("spacedesc", "personalspacedesc"), null, -1, httpServletRequest);
        ArrayList result = Lists.newArrayList();
        for (List matchList : searchResult.getContentNameMatches()) {
            for (ContentNameMatch match : matchList) {
                Space space;
                MappingFolder folder;
                if (StringUtils.isBlank((String)match.getSpaceKey()) || (folder = this.mappingFolderService.getFolderBySpaceId((space = this.spaceManager.getSpace(match.getSpaceKey())).getId())) == null || !this.featurePermissionResourceHelper.hasBrowsePanelAndBrowseSpace(space, loggedInUser)) continue;
                result.add(space);
                if (result.size() < maxResults) continue;
                return result;
            }
        }
        return result;
    }

    private List<Space> findAllSpace(ConfluenceUser loggedInUser, Integer maxResults) {
        List<MappingFolder> folders = this.mappingFolderService.getFolders();
        HashSet<Long> spaceIds = new HashSet<Long>();
        for (MappingFolder folder : folders) {
            for (Long spaceId : folder.getSpaceIds()) {
                spaceIds.add(spaceId);
            }
        }
        ArrayList spaces = Lists.newArrayList();
        for (Long spaceId : spaceIds) {
            Space space = this.spaceManager.getSpace(spaceId.longValue());
            if (space == null || !this.featurePermissionResourceHelper.hasBrowsePanelAndBrowseSpace(space, loggedInUser)) continue;
            spaces.add(space);
            if (spaces.size() < maxResults) continue;
            return spaces;
        }
        return spaces;
    }
}

