/*
 * Decompiled with CFR 0.152.
 */
package jp.ricksoft.plugins.alfresco.license;

import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.atlassian.user.User;
import jp.ricksoft.plugins.alfresco.license.LicenseManager;

public class LicenseManagerImpl
implements LicenseManager {
    private final PluginLicenseManager licenseManager;
    private final PermissionManager permissionManager;

    public LicenseManagerImpl(PluginLicenseManager licenseManager, PermissionManager permissionManager) {
        this.licenseManager = licenseManager;
        this.permissionManager = permissionManager;
    }

    @Override
    public boolean isInvalidLicense() {
        if (this.licenseManager.getLicense().isDefined()) {
            PluginLicense pluginLicense = (PluginLicense)this.licenseManager.getLicense().get();
            return pluginLicense.getError().isDefined();
        }
        return true;
    }

    @Override
    public String getRedirectUrl(ConfluenceUser user) {
        if (this.isSystemAdmin((User)user)) {
            return "/plugins/servlet/upm#manage/jp.ricksoft.plugins.alfresco-for-confluence";
        }
        return "/plugins/alfresco_for_confluence/needlicense.action";
    }

    public boolean isSystemAdmin(User user) {
        return this.permissionManager.hasPermission(user, Permission.ADMINISTER, PermissionManager.TARGET_APPLICATION);
    }
}

