/*
 * Decompiled with CFR 0.152.
 */
package jp.ricksoft.plugins.alfresco.ao.service.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import jp.ricksoft.plugins.alfresco.ao.service.jdbc.Dialect;
import jp.ricksoft.plugins.alfresco.ao.service.jdbc.H2Dialect;
import jp.ricksoft.plugins.alfresco.ao.service.jdbc.HSQLDialect;
import jp.ricksoft.plugins.alfresco.ao.service.jdbc.MySQLDialect;
import jp.ricksoft.plugins.alfresco.ao.service.jdbc.OracleDialect;
import jp.ricksoft.plugins.alfresco.ao.service.jdbc.PostgreSQLDialect;
import jp.ricksoft.plugins.alfresco.ao.service.jdbc.SQLServerDialect;

public class DialectFactory {
    private static final Dialect H2Dialect = new H2Dialect();
    private static final Dialect HSQLDialect = new HSQLDialect();
    private static final Dialect PostgreSQLDialect = new PostgreSQLDialect();
    private static final Dialect SQLServerDialect = new SQLServerDialect();
    private static final Dialect MySQLDialect = new MySQLDialect();
    private static final Dialect OracleDialect = new OracleDialect();

    public static Dialect getDialect(Connection connection) throws SQLException {
        String databaseProductName;
        try {
            databaseProductName = connection.getMetaData().getDatabaseProductName().toLowerCase();
        }
        catch (SQLException e) {
            throw new RuntimeException("everything went wrong while trying to retrieve the DB connection's driver name", e);
        }
        if (databaseProductName.equals("h2")) {
            return H2Dialect;
        }
        if (databaseProductName.startsWith("hsql")) {
            return HSQLDialect;
        }
        if (databaseProductName.equals("postgresql")) {
            return PostgreSQLDialect;
        }
        if (databaseProductName.equals("oracle")) {
            return OracleDialect;
        }
        if (databaseProductName.equals("mysql")) {
            return MySQLDialect;
        }
        if (databaseProductName.startsWith("microsoft")) {
            return SQLServerDialect;
        }
        throw new RuntimeException("unable to map the DB connection's driver product name '" + databaseProductName + "' to a Hibernate dialect class");
    }
}

