/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.client.runtime;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.chemistry.opencmis.client.api.Document;
import org.apache.chemistry.opencmis.client.api.DocumentType;
import org.apache.chemistry.opencmis.client.api.ObjectFactory;
import org.apache.chemistry.opencmis.client.api.ObjectId;
import org.apache.chemistry.opencmis.client.api.ObjectType;
import org.apache.chemistry.opencmis.client.api.OperationContext;
import org.apache.chemistry.opencmis.client.api.Policy;
import org.apache.chemistry.opencmis.client.api.Property;
import org.apache.chemistry.opencmis.client.bindings.spi.LinkAccess;
import org.apache.chemistry.opencmis.client.runtime.AbstractFilableCmisObject;
import org.apache.chemistry.opencmis.client.runtime.SessionImpl;
import org.apache.chemistry.opencmis.client.runtime.util.AppendOutputStream;
import org.apache.chemistry.opencmis.commons.data.Ace;
import org.apache.chemistry.opencmis.commons.data.ContentStream;
import org.apache.chemistry.opencmis.commons.data.ContentStreamHash;
import org.apache.chemistry.opencmis.commons.data.ObjectData;
import org.apache.chemistry.opencmis.commons.data.PartialContentStream;
import org.apache.chemistry.opencmis.commons.enums.CmisVersion;
import org.apache.chemistry.opencmis.commons.enums.IncludeRelationships;
import org.apache.chemistry.opencmis.commons.enums.Updatability;
import org.apache.chemistry.opencmis.commons.enums.VersioningState;
import org.apache.chemistry.opencmis.commons.exceptions.CmisNotSupportedException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.commons.impl.CollectionsHelper;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.ContentStreamHashImpl;
import org.apache.chemistry.opencmis.commons.spi.Holder;

public class DocumentImpl
extends AbstractFilableCmisObject
implements Document {
    private static final long serialVersionUID = 1L;

    public DocumentImpl(SessionImpl session, ObjectType objectType, ObjectData objectData, OperationContext context) {
        this.initialize(session, objectType, objectData, context);
    }

    @Override
    public DocumentType getDocumentType() {
        ObjectType objectType = super.getType();
        if (objectType instanceof DocumentType) {
            return (DocumentType)objectType;
        }
        throw new ClassCastException("Object type is not a document type.");
    }

    @Override
    public boolean isVersionable() {
        return Boolean.TRUE.equals(this.getDocumentType().isVersionable());
    }

    @Override
    public Boolean isVersionSeriesPrivateWorkingCopy() {
        if (Boolean.FALSE.equals(this.getDocumentType().isVersionable())) {
            return false;
        }
        Boolean isCheckedOut = this.isVersionSeriesCheckedOut();
        if (Boolean.FALSE.equals(isCheckedOut)) {
            return false;
        }
        Boolean isPWC = this.isPrivateWorkingCopy();
        if (isPWC != null) {
            return isPWC;
        }
        String vsCoId = this.getVersionSeriesCheckedOutId();
        if (vsCoId == null) {
            return null;
        }
        return vsCoId.equals(this.getId());
    }

    @Override
    public String getCheckinComment() {
        return (String)this.getPropertyValue("cmis:checkinComment");
    }

    @Override
    public String getVersionLabel() {
        return (String)this.getPropertyValue("cmis:versionLabel");
    }

    @Override
    public String getVersionSeriesId() {
        return (String)this.getPropertyValue("cmis:versionSeriesId");
    }

    @Override
    public String getVersionSeriesCheckedOutId() {
        return (String)this.getPropertyValue("cmis:versionSeriesCheckedOutId");
    }

    @Override
    public String getVersionSeriesCheckedOutBy() {
        return (String)this.getPropertyValue("cmis:versionSeriesCheckedOutBy");
    }

    @Override
    public Boolean isImmutable() {
        return (Boolean)this.getPropertyValue("cmis:isImmutable");
    }

    @Override
    public Boolean isLatestMajorVersion() {
        return (Boolean)this.getPropertyValue("cmis:isLatestMajorVersion");
    }

    @Override
    public Boolean isLatestVersion() {
        return (Boolean)this.getPropertyValue("cmis:isLatestVersion");
    }

    @Override
    public Boolean isMajorVersion() {
        return (Boolean)this.getPropertyValue("cmis:isMajorVersion");
    }

    @Override
    public Boolean isPrivateWorkingCopy() {
        return (Boolean)this.getPropertyValue("cmis:isPrivateWorkingCopy");
    }

    @Override
    public Boolean isVersionSeriesCheckedOut() {
        return (Boolean)this.getPropertyValue("cmis:isVersionSeriesCheckedOut");
    }

    @Override
    public long getContentStreamLength() {
        BigInteger bigInt = (BigInteger)this.getPropertyValue("cmis:contentStreamLength");
        return bigInt == null ? -1L : bigInt.longValue();
    }

    @Override
    public String getContentStreamMimeType() {
        return (String)this.getPropertyValue("cmis:contentStreamMimeType");
    }

    @Override
    public String getContentStreamFileName() {
        return (String)this.getPropertyValue("cmis:contentStreamFileName");
    }

    @Override
    public String getContentStreamId() {
        return (String)this.getPropertyValue("cmis:contentStreamId");
    }

    @Override
    public List<ContentStreamHash> getContentStreamHashes() {
        List hashes = (List)this.getPropertyValue("cmis:contentStreamHash");
        if (CollectionsHelper.isNullOrEmpty(hashes)) {
            return null;
        }
        ArrayList<ContentStreamHash> result = new ArrayList<ContentStreamHash>(hashes.size());
        for (String hash : hashes) {
            result.add(new ContentStreamHashImpl(hash));
        }
        return result;
    }

    @Override
    public String getLatestAccessibleStateId() {
        return (String)this.getPropertyValue("cmis:latestAccessibleStateId");
    }

    @Override
    public Document copy(ObjectId targetFolderId, Map<String, ?> properties, VersioningState versioningState, List<Policy> policies, List<Ace> addAces, List<Ace> removeAces, OperationContext context) {
        ObjectId newId = null;
        try {
            newId = this.getSession().createDocumentFromSource(this, properties, targetFolderId, versioningState, policies, addAces, removeAces);
        }
        catch (CmisNotSupportedException nse) {
            newId = this.copyViaClient(targetFolderId, properties, versioningState, policies, addAces, removeAces);
        }
        if (context == null || newId == null) {
            return null;
        }
        CmisObject object = this.getSession().getObject(newId, context);
        if (!(object instanceof Document)) {
            throw new CmisRuntimeException("Newly created object is not a document! New id: " + newId);
        }
        return (Document)object;
    }

    @Override
    public Document copy(ObjectId targetFolderId) {
        return this.copy(targetFolderId, null, null, null, null, null, this.getSession().getDefaultContext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ObjectId copyViaClient(ObjectId targetFolderId, Map<String, ?> properties, VersioningState versioningState, List<Policy> policies, List<Ace> addAces, List<Ace> removeAces) {
        HashMap<String, Object> newProperties = new HashMap<String, Object>();
        OperationContext allPropsContext = this.getSession().createOperationContext();
        allPropsContext.setFilterString("*");
        allPropsContext.setIncludeAcls(false);
        allPropsContext.setIncludeAllowableActions(false);
        allPropsContext.setIncludePathSegments(false);
        allPropsContext.setIncludePolicies(false);
        allPropsContext.setIncludeRelationships(IncludeRelationships.NONE);
        allPropsContext.setRenditionFilterString("cmis:none");
        Document allPropsDoc = (Document)this.getSession().getObject(this, allPropsContext);
        for (Property<?> prop : allPropsDoc.getProperties()) {
            if (prop.getDefinition().getUpdatability() != Updatability.READWRITE && prop.getDefinition().getUpdatability() != Updatability.ONCREATE) continue;
            newProperties.put(prop.getId(), prop.getValue());
        }
        if (properties != null) {
            newProperties.putAll(properties);
        }
        ContentStream contentStream = allPropsDoc.getContentStream();
        try {
            ObjectId objectId = this.getSession().createDocument(newProperties, targetFolderId, contentStream, versioningState, policies, addAces, removeAces);
            return objectId;
        }
        finally {
            InputStream stream;
            if (contentStream != null && (stream = contentStream.getStream()) != null) {
                try {
                    stream.close();
                }
                catch (IOException ioe) {
                    throw new CmisRuntimeException("Cannot close source stream!", ioe);
                }
            }
        }
    }

    @Override
    public void deleteAllVersions() {
        this.delete(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ObjectId checkOut() {
        String newObjectId = null;
        this.readLock();
        try {
            String objectId = this.getObjectId();
            Holder<String> objectIdHolder = new Holder<String>(objectId);
            this.getBinding().getVersioningService().checkOut(this.getRepositoryId(), objectIdHolder, null, null);
            newObjectId = objectIdHolder.getValue();
        }
        finally {
            this.readUnlock();
        }
        this.getSession().removeObjectFromCache(this);
        if (newObjectId == null) {
            return null;
        }
        return this.getSession().createObjectId(newObjectId);
    }

    @Override
    public void cancelCheckOut() {
        String objectId = this.getObjectId();
        this.getBinding().getVersioningService().cancelCheckOut(this.getRepositoryId(), objectId, null);
        this.getSession().removeObjectFromCache(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ObjectId checkIn(boolean major, Map<String, ?> properties, ContentStream contentStream, String checkinComment, List<Policy> policies, List<Ace> addAces, List<Ace> removeAces) {
        String newObjectId = null;
        this.readLock();
        try {
            Holder<String> objectIdHolder = new Holder<String>(this.getObjectId());
            ObjectFactory of = this.getObjectFactory();
            EnumSet<Updatability> updatebility = EnumSet.noneOf(Updatability.class);
            updatebility.add(Updatability.READWRITE);
            updatebility.add(Updatability.WHENCHECKEDOUT);
            this.getBinding().getVersioningService().checkIn(this.getRepositoryId(), objectIdHolder, major, of.convertProperties(properties, this.getType(), this.getSecondaryTypes(), updatebility), of.convertContentStream(contentStream), checkinComment, of.convertPolicies(policies), of.convertAces(addAces), of.convertAces(removeAces), null);
            newObjectId = objectIdHolder.getValue();
        }
        finally {
            this.readUnlock();
        }
        this.getSession().removeObjectFromCache(this);
        if (newObjectId == null) {
            return null;
        }
        return this.getSession().createObjectId(newObjectId);
    }

    @Override
    public List<Document> getAllVersions() {
        return this.getAllVersions(this.getSession().getDefaultContext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Document> getAllVersions(OperationContext context) {
        String versionSeriesId;
        String objectId;
        this.checkContext(context);
        this.readLock();
        try {
            objectId = this.getObjectId();
            versionSeriesId = this.getVersionSeriesId();
        }
        finally {
            this.readUnlock();
        }
        List<ObjectData> versions = this.getBinding().getVersioningService().getAllVersions(this.getRepositoryId(), objectId, versionSeriesId, context.getFilterString(), context.isIncludeAllowableActions(), null);
        ObjectFactory objectFactory = this.getSession().getObjectFactory();
        ArrayList<Document> result = new ArrayList<Document>();
        if (versions != null) {
            for (ObjectData objectData : versions) {
                CmisObject doc = objectFactory.convertObject(objectData, context);
                if (!(doc instanceof Document)) continue;
                result.add((Document)doc);
            }
        }
        return result;
    }

    @Override
    public Document getObjectOfLatestVersion(boolean major) {
        return this.getObjectOfLatestVersion(major, this.getSession().getDefaultContext());
    }

    @Override
    public Document getObjectOfLatestVersion(boolean major, OperationContext context) {
        return this.getSession().getLatestDocumentVersion(this, major, context);
    }

    @Override
    public ContentStream getContentStream() {
        return this.getContentStream(null, null, null);
    }

    @Override
    public ContentStream getContentStream(BigInteger offset, BigInteger length) {
        return this.getContentStream(null, offset, length);
    }

    @Override
    public ContentStream getContentStream(String streamId) {
        return this.getContentStream(streamId, null, null);
    }

    @Override
    public ContentStream getContentStream(String streamId, BigInteger offset, BigInteger length) {
        ContentStream contentStream = this.getSession().getContentStream(this, streamId, offset, length);
        if (contentStream == null) {
            return null;
        }
        String filename = contentStream.getFileName();
        if (filename == null) {
            filename = this.getContentStreamFileName();
        }
        long lengthLong = contentStream.getBigLength() == null ? -1L : contentStream.getBigLength().longValue();
        return this.getSession().getObjectFactory().createContentStream(filename, lengthLong, contentStream.getMimeType(), contentStream.getStream(), contentStream instanceof PartialContentStream);
    }

    @Override
    public String getContentUrl() {
        return this.getContentUrl(null);
    }

    @Override
    public String getContentUrl(String streamId) {
        if (this.getBinding().getObjectService() instanceof LinkAccess) {
            LinkAccess linkAccess = (LinkAccess)((Object)this.getBinding().getObjectService());
            if (streamId == null) {
                return linkAccess.loadContentLink(this.getRepositoryId(), this.getId());
            }
            return linkAccess.loadRenditionContentLink(this.getRepositoryId(), this.getId(), streamId);
        }
        return null;
    }

    @Override
    public Document setContentStream(ContentStream contentStream, boolean overwrite) {
        ObjectId objectId = this.setContentStream(contentStream, overwrite, true);
        if (objectId == null) {
            return null;
        }
        if (!this.getObjectId().equals(objectId.getId())) {
            return (Document)this.getSession().getObject(objectId, this.getCreationContext());
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ObjectId setContentStream(ContentStream contentStream, boolean overwrite, boolean refresh) {
        String newObjectId = null;
        this.readLock();
        try {
            Holder<String> objectIdHolder = new Holder<String>(this.getObjectId());
            Holder<String> changeTokenHolder = new Holder<String>((String)this.getPropertyValue("cmis:changeToken"));
            this.getBinding().getObjectService().setContentStream(this.getRepositoryId(), objectIdHolder, overwrite, changeTokenHolder, this.getObjectFactory().convertContentStream(contentStream), null);
            newObjectId = objectIdHolder.getValue();
        }
        finally {
            this.readUnlock();
        }
        if (refresh) {
            this.refresh();
        }
        if (newObjectId == null) {
            return null;
        }
        return this.getSession().createObjectId(newObjectId);
    }

    @Override
    public Document appendContentStream(ContentStream contentStream, boolean isLastChunk) {
        if (this.getSession().getRepositoryInfo().getCmisVersion() == CmisVersion.CMIS_1_0) {
            throw new CmisNotSupportedException("This method is not supported for CMIS 1.0 repositories.");
        }
        ObjectId objectId = this.appendContentStream(contentStream, isLastChunk, true);
        if (objectId == null) {
            return null;
        }
        if (!this.getObjectId().equals(objectId.getId())) {
            return (Document)this.getSession().getObject(objectId, this.getCreationContext());
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ObjectId appendContentStream(ContentStream contentStream, boolean isLastChunk, boolean refresh) {
        if (this.getSession().getRepositoryInfo().getCmisVersion() == CmisVersion.CMIS_1_0) {
            throw new CmisNotSupportedException("This method is not supported for CMIS 1.0 repositories.");
        }
        String newObjectId = null;
        this.readLock();
        try {
            Holder<String> objectIdHolder = new Holder<String>(this.getObjectId());
            Holder<String> changeTokenHolder = new Holder<String>((String)this.getPropertyValue("cmis:changeToken"));
            this.getBinding().getObjectService().appendContentStream(this.getRepositoryId(), objectIdHolder, changeTokenHolder, this.getObjectFactory().convertContentStream(contentStream), isLastChunk, null);
            newObjectId = objectIdHolder.getValue();
        }
        finally {
            this.readUnlock();
        }
        if (refresh) {
            this.refresh();
        }
        if (newObjectId == null) {
            return null;
        }
        return this.getSession().createObjectId(newObjectId);
    }

    @Override
    public Document deleteContentStream() {
        ObjectId objectId = this.deleteContentStream(true);
        if (objectId == null) {
            return null;
        }
        if (!this.getObjectId().equals(objectId.getId())) {
            return (Document)this.getSession().getObject(objectId, this.getCreationContext());
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ObjectId deleteContentStream(boolean refresh) {
        String newObjectId = null;
        this.readLock();
        try {
            Holder<String> objectIdHolder = new Holder<String>(this.getObjectId());
            Holder<String> changeTokenHolder = new Holder<String>((String)this.getPropertyValue("cmis:changeToken"));
            this.getBinding().getObjectService().deleteContentStream(this.getRepositoryId(), objectIdHolder, changeTokenHolder, null);
            newObjectId = objectIdHolder.getValue();
        }
        finally {
            this.readUnlock();
        }
        if (refresh) {
            this.refresh();
        }
        if (newObjectId == null) {
            return null;
        }
        return this.getSession().createObjectId(newObjectId);
    }

    @Override
    public OutputStream createOverwriteOutputStream(String filename, String mimeType) {
        if (this.getSession().getRepositoryInfo().getCmisVersion() == CmisVersion.CMIS_1_0) {
            throw new CmisNotSupportedException("This method is not supported for CMIS 1.0 repositories.");
        }
        return new AppendOutputStream(this.getSession(), this, true, filename, mimeType);
    }

    @Override
    public OutputStream createOverwriteOutputStream(String filename, String mimeType, int bufferSize) {
        if (this.getSession().getRepositoryInfo().getCmisVersion() == CmisVersion.CMIS_1_0) {
            throw new CmisNotSupportedException("This method is not supported for CMIS 1.0 repositories.");
        }
        return new AppendOutputStream(this.getSession(), this, true, filename, mimeType, bufferSize);
    }

    @Override
    public OutputStream createAppendOutputStream() {
        if (this.getSession().getRepositoryInfo().getCmisVersion() == CmisVersion.CMIS_1_0) {
            throw new CmisNotSupportedException("This method is not supported for CMIS 1.0 repositories.");
        }
        return new AppendOutputStream(this.getSession(), this, false, null, null);
    }

    @Override
    public OutputStream createAppendOutputStream(int bufferSize) {
        if (this.getSession().getRepositoryInfo().getCmisVersion() == CmisVersion.CMIS_1_0) {
            throw new CmisNotSupportedException("This method is not supported for CMIS 1.0 repositories.");
        }
        return new AppendOutputStream(this.getSession(), this, false, null, null, bufferSize);
    }

    @Override
    public ObjectId checkIn(boolean major, Map<String, ?> properties, ContentStream contentStream, String checkinComment) {
        return this.checkIn(major, properties, contentStream, checkinComment, null, null, null);
    }
}

