/*
 * Decompiled with CFR 0.152.
 */
package jp.ricksoft.plugins.alfresco.rest.healthcheck;

import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.fugue.Pair;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.soy.renderer.SoyTemplateRenderer;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import jp.ricksoft.plugins.alfresco.ao.entity.CredentialEntity;
import jp.ricksoft.plugins.alfresco.ao.service.CredentialService;
import jp.ricksoft.plugins.alfresco.rest.healthcheck.HealthCheckBean;
import jp.ricksoft.plugins.alfresco.rest.healthcheck.HealthCheckItem;
import jp.ricksoft.plugins.alfresco.rest.healthcheck.HealthCheckStatus;

public class HealthCheckOrigin
extends HealthCheckItem {
    private static final String ID = "origin";
    private final CredentialService credentialService;

    public HealthCheckOrigin(I18nResolver i18n, SoyTemplateRenderer soyRenderer, CredentialService credentialService) {
        super(i18n, soyRenderer);
        this.credentialService = credentialService;
    }

    @Override
    HealthCheckBean check(HttpServletRequest request, ConfluenceUser user) {
        CredentialEntity credential = this.credentialService.find();
        if (this.getOrigin(credential.getAlfrescoDisplayUrl()).startsWith(this.getOrigin(request.getRequestURL().toString()))) {
            return new HealthCheckBean(ID, this.getText("alfresco.for.confluence.admin.healthcheck.origin.title"), HealthCheckStatus.SUCCESS, this.getText("alfresco.for.confluence.admin.healthcheck.origin.success.message"));
        }
        String requestUrl = request.getRequestURL().toString();
        int lastIndex = requestUrl.lastIndexOf("/rest/alfresco/1.0/healthcheck");
        String accessBaseUrl = requestUrl.substring(0, lastIndex);
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("confluencelink", this.hilightOrigin(accessBaseUrl, "<b>", "</b>"));
        data.put("alfrescolink", this.hilightOrigin(credential.getAlfrescoDisplayUrl(), "<b>", "</b>"));
        String renderedMessage = this.getSoyRenderer().render("jp.ricksoft.plugins.alfresco-for-confluence:admin-credential-resources", "Connector.Templates.credential.nomatchOrigin", data);
        return new HealthCheckBean(ID, this.getText("alfresco.for.confluence.admin.healthcheck.origin.title"), HealthCheckStatus.WARN, renderedMessage);
    }

    private String getOrigin(String url) {
        Matcher m = Pattern.compile("((http|https)?://[^/]+)").matcher(url);
        if (m.find()) {
            return m.group(1);
        }
        return "";
    }

    private String hilightOrigin(String url, String prefix, String suffix) {
        Pair<String, String> pair = this.parseOrigin(url);
        return prefix + (String)pair.left() + suffix + (String)pair.right();
    }

    private Pair<String, String> parseOrigin(String url) {
        int index = url.indexOf("//");
        if (index == -1) {
            return new Pair((Object)url, (Object)"");
        }
        if ((index = url.indexOf("/", index + "//".length())) == -1) {
            return new Pair((Object)url, (Object)"");
        }
        String origin = url.substring(0, index);
        String path = url.substring(index);
        return new Pair((Object)origin, (Object)path);
    }
}

