/*
 * Decompiled with CFR 0.152.
 */
package jp.ricksoft.plugins.alfresco.rest.healthcheck;

import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.soy.renderer.SoyTemplateRenderer;
import javax.servlet.http.HttpServletRequest;
import jp.ricksoft.plugins.alfresco.ao.entity.CredentialEntity;
import jp.ricksoft.plugins.alfresco.ao.service.CredentialService;
import jp.ricksoft.plugins.alfresco.rest.healthcheck.HealthCheckBean;
import jp.ricksoft.plugins.alfresco.rest.healthcheck.HealthCheckItem;
import jp.ricksoft.plugins.alfresco.rest.healthcheck.HealthCheckStatus;

public class HealthCheckMixedContent
extends HealthCheckItem {
    private static final String ID = "mixedcontent";
    private final CredentialService credentialService;

    public HealthCheckMixedContent(I18nResolver i18n, SoyTemplateRenderer soyRenderer, CredentialService credentialService) {
        super(i18n, soyRenderer);
        this.credentialService = credentialService;
    }

    @Override
    HealthCheckBean check(HttpServletRequest request, ConfluenceUser user) {
        CredentialEntity credential = this.credentialService.find();
        String requestURL = request.getRequestURL().toString().toLowerCase();
        String alfrescoURL = credential.getAlfrescoDisplayUrl().toLowerCase();
        if (requestURL.startsWith("https://") && alfrescoURL.startsWith("http://")) {
            return new HealthCheckBean(ID, this.getText("alfresco.for.confluence.admin.healthcheck.mixedcontent.title"), HealthCheckStatus.ERROR, this.getText("alfresco.for.confluence.admin.healthcheck.mixedcontent.error.message"));
        }
        return null;
    }
}

