/*
 * Decompiled with CFR 0.152.
 */
package jp.ricksoft.plugins.alfresco.rest;

import com.atlassian.confluence.compat.api.service.accessmode.ReadOnlyAccessAllowed;
import com.atlassian.confluence.core.ConfluenceSidManager;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.sal.api.message.I18nResolver;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import jp.ricksoft.plugins.alfresco.ao.entity.DocumentLinkEntity;
import jp.ricksoft.plugins.alfresco.ao.service.DocumentLinkService;
import jp.ricksoft.plugins.alfresco.ao.service.DocumentLinkStreamCallback;
import jp.ricksoft.plugins.alfresco.ao.service.MappingFolderService;
import jp.ricksoft.plugins.alfresco.rest.DocumentLink;
import jp.ricksoft.plugins.alfresco.rest.DocumentLinkPage;
import jp.ricksoft.plugins.alfresco.rest.DocumentLinks;
import jp.ricksoft.plugins.alfresco.rest.permission.FeaturePermissionResourceHelper;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

@Path(value="/link")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class DocumentLinkResource {
    private static final Logger log = Logger.getLogger(DocumentLinkResource.class);
    private static final Integer DEFAULT_START_OFFSET = new Integer(0);
    private static final Integer DEFAULT_LIMIT = new Integer(10);
    private static final Integer DEFAULT_MAX_START_OFFSET = new Integer(100000);
    private static final Integer DEFAULT_MAX_LIMIT = new Integer(100);
    private final PageManager pageManager;
    private final SpaceManager spaceManager;
    private final UserAccessor userAccessor;
    private final I18nResolver i18n;
    private final ConfluenceSidManager sidManager;
    private final DocumentLinkService documentLinkService;
    private final MappingFolderService mappingFolderService;
    private final FeaturePermissionResourceHelper featurePermissionResourceHelper;

    public DocumentLinkResource(ConfluenceSidManager sidManager, PageManager pageManager, SpaceManager spaceManager, UserAccessor userAccessor, I18nResolver i18n, DocumentLinkService documentLinkService, MappingFolderService mappingFolderService, FeaturePermissionResourceHelper featurePermissionResourceHelper) {
        this.sidManager = sidManager;
        this.pageManager = pageManager;
        this.spaceManager = spaceManager;
        this.userAccessor = userAccessor;
        this.i18n = i18n;
        this.documentLinkService = documentLinkService;
        this.mappingFolderService = mappingFolderService;
        this.featurePermissionResourceHelper = featurePermissionResourceHelper;
    }

    @GET
    @Path(value="/page/{pageId}/object")
    public Response getObjectByIssue(@Context HttpServletRequest request, @PathParam(value="pageId") Long pageId, @QueryParam(value="start") Integer start, @QueryParam(value="limit") Integer limit) {
        String serverId = this.getServerId();
        if (StringUtils.isEmpty((CharSequence)serverId)) {
            return Response.serverError().build();
        }
        ConfluenceUser loggedInUser = AuthenticatedUserThreadLocal.get();
        if (loggedInUser == null) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        if (pageId == 0L) {
            return Response.ok(new DocumentLinkPage(start, limit, 0, Lists.newArrayList())).build();
        }
        AbstractPage page = this.pageManager.getAbstractPage(pageId.longValue());
        if (page == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        Space space = page.getSpace();
        if (space == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        start = start == null || start < 0 ? DEFAULT_START_OFFSET : Math.min(start, DEFAULT_MAX_START_OFFSET);
        limit = limit == null || limit < 0 ? DEFAULT_LIMIT : Math.min(limit, DEFAULT_MAX_LIMIT);
        int size = this.documentLinkService.countObjectId(page);
        List<String> objectIds = this.documentLinkService.findObjectId(page, (int)start, (int)limit);
        return Response.ok(new DocumentLinkPage<String>(start, limit, size, objectIds)).build();
    }

    @GET
    @Path(value="/space/{spaceKey}/object")
    public Response getObjectIdByProject(@Context HttpServletRequest request, @PathParam(value="spaceKey") String spaceKey, @QueryParam(value="start") Integer start, @QueryParam(value="limit") Integer limit) {
        String serverId = this.getServerId();
        if (StringUtils.isEmpty((CharSequence)serverId)) {
            return Response.serverError().build();
        }
        ConfluenceUser loggedInUser = AuthenticatedUserThreadLocal.get();
        if (loggedInUser == null) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        Space space = this.spaceManager.getSpace(spaceKey);
        if (space == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        start = start == null || start < 0 ? DEFAULT_START_OFFSET : Math.min(start, DEFAULT_MAX_START_OFFSET);
        limit = limit == null || limit < 0 ? DEFAULT_LIMIT : Math.min(limit, DEFAULT_MAX_LIMIT);
        int size = this.documentLinkService.countObjectId(space);
        List<String> objectIds = this.documentLinkService.findObjectId(space, (int)start, (int)limit);
        return Response.ok(new DocumentLinkPage<String>(start, limit, size, objectIds)).build();
    }

    @POST
    @Path(value="/objects")
    @ReadOnlyAccessAllowed
    public Response getLinkByObjects(@Context HttpServletRequest request, DocumentLinkRequest documentLinkRequest) {
        List<String> objectIds = documentLinkRequest.getObjectId();
        String serverId = this.getServerId();
        if (StringUtils.isEmpty((CharSequence)serverId)) {
            return Response.serverError().build();
        }
        final ConfluenceUser loggedInUser = AuthenticatedUserThreadLocal.get();
        if (loggedInUser == null) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        final DocumentLinks links = new DocumentLinks();
        this.documentLinkService.streamEntityByObjectId(objectIds, new DocumentLinkStreamCallback(){

            @Override
            public void valueRead(DocumentLinkEntity entity) {
                String username = DocumentLinkResource.this.userKey2username(entity.getAuthorKey());
                DocumentLink link = new DocumentLink(entity.getSpaceId(), entity.getPageId(), entity.getObjectId(), entity.getAuthorKey(), username, entity.getCreated());
                AbstractPage page = DocumentLinkResource.this.pageManager.getAbstractPage(entity.getPageId());
                link.setEnableUnlink(DocumentLinkResource.this.featurePermissionResourceHelper.canUnlinkDocument(page, link, loggedInUser));
                links.addLink(link);
            }
        });
        return Response.ok((Object)links).build();
    }

    @POST
    @Path(value="/page/{pageId}")
    public Response addLinkByPage(@Context HttpServletRequest request, @PathParam(value="pageId") Long pageId, DocumentLinkRequest documentLinkRequest) {
        List<String> objectIds = documentLinkRequest.getObjectId();
        final ConfluenceUser loggedInUser = AuthenticatedUserThreadLocal.get();
        if (loggedInUser == null) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        if (pageId == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        final AbstractPage page = this.pageManager.getAbstractPage(pageId.longValue());
        if (page == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        Space space = page.getSpace();
        if (space == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        if (objectIds == null || objectIds.isEmpty()) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        if (!this.featurePermissionResourceHelper.canLinkDocument(page, loggedInUser)) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        Long spaceId = space.getId();
        String spaceKey = space.getKey();
        this.documentLinkService.save(page, objectIds, loggedInUser);
        final DocumentLinks links = new DocumentLinks();
        this.documentLinkService.streamEntityByObjectId(objectIds, new DocumentLinkStreamCallback(){

            @Override
            public void valueRead(DocumentLinkEntity entity) {
                String username = DocumentLinkResource.this.userKey2username(entity.getAuthorKey());
                DocumentLink link = new DocumentLink(entity.getSpaceId(), entity.getPageId(), entity.getObjectId(), entity.getAuthorKey(), username, entity.getCreated());
                link.setEnableUnlink(DocumentLinkResource.this.featurePermissionResourceHelper.canUnlinkDocument(page, link, loggedInUser));
                links.addLink(link);
            }
        });
        return Response.ok((Object)links).build();
    }

    @POST
    @Path(value="/object/{objectId}")
    public Response addLinkByObject(@Context HttpServletRequest request, @PathParam(value="objectId") String objectId, DocumentLinkRequest documentLinkRequest) {
        List<Long> pageIds = documentLinkRequest.getPageId();
        final ConfluenceUser loggedInUser = AuthenticatedUserThreadLocal.get();
        if (loggedInUser == null) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        if (objectId == null || objectId.isEmpty()) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        if (pageIds == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        ArrayList<AbstractPage> pages = new ArrayList<AbstractPage>();
        for (Long pageId : pageIds) {
            AbstractPage page = this.pageManager.getAbstractPage(pageId.longValue());
            if (page == null) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
            Space space = page.getSpace();
            if (space == null) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
            if (!this.featurePermissionResourceHelper.canLinkDocument(page, loggedInUser)) {
                return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
            }
            pages.add(page);
        }
        this.documentLinkService.save(pages, objectId, loggedInUser);
        final DocumentLinks links = new DocumentLinks();
        this.documentLinkService.streamEntityByObjectId(Arrays.asList(objectId), new DocumentLinkStreamCallback(){

            @Override
            public void valueRead(DocumentLinkEntity entity) {
                String username = DocumentLinkResource.this.userKey2username(entity.getAuthorKey());
                DocumentLink link = new DocumentLink(entity.getSpaceId(), entity.getPageId(), entity.getObjectId(), entity.getAuthorKey(), username, entity.getCreated());
                AbstractPage page = DocumentLinkResource.this.pageManager.getAbstractPage(entity.getPageId());
                link.setEnableUnlink(DocumentLinkResource.this.featurePermissionResourceHelper.canUnlinkDocument(page, link, loggedInUser));
                links.addLink(link);
            }
        });
        return Response.ok((Object)links).build();
    }

    @DELETE
    @Path(value="/page/{pageId}")
    public Response removeLinkByPage(@Context HttpServletRequest request, @PathParam(value="pageId") Long pageId, DocumentLinkRequest documentLinkRequest) {
        List<String> objectIds = documentLinkRequest.getObjectId();
        final ConfluenceUser loggedInUser = AuthenticatedUserThreadLocal.get();
        if (loggedInUser == null) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        if (pageId == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        final AbstractPage page = this.pageManager.getAbstractPage(pageId.longValue());
        if (page == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        Space space = page.getSpace();
        if (space == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        if (objectIds == null || objectIds.isEmpty()) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        Long spaceId = space.getId();
        String spaceKey = space.getKey();
        if (!this.canUnlinkDocument(page, objectIds, loggedInUser)) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        this.documentLinkService.delete(page, objectIds);
        final DocumentLinks links = new DocumentLinks();
        this.documentLinkService.streamEntityByObjectId(objectIds, new DocumentLinkStreamCallback(){

            @Override
            public void valueRead(DocumentLinkEntity entity) {
                String username = DocumentLinkResource.this.userKey2username(entity.getAuthorKey());
                DocumentLink link = new DocumentLink(entity.getSpaceId(), entity.getPageId(), entity.getObjectId(), entity.getAuthorKey(), username, entity.getCreated());
                link.setEnableUnlink(DocumentLinkResource.this.featurePermissionResourceHelper.canUnlinkDocument(page, link, loggedInUser));
                links.addLink(link);
            }
        });
        return Response.ok((Object)links).build();
    }

    @DELETE
    @Path(value="/object/{objectId}")
    public Response removeLinkByObject(@Context HttpServletRequest request, @PathParam(value="objectId") String objectId, DocumentLinkRequest documentLinkRequest) {
        List<Long> pageIds = documentLinkRequest.getPageId();
        final ConfluenceUser loggedInUser = AuthenticatedUserThreadLocal.get();
        if (loggedInUser == null) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        if (objectId == null || objectId.isEmpty()) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        if (pageIds == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        ArrayList<AbstractPage> pages = new ArrayList<AbstractPage>();
        for (Long pageId : pageIds) {
            AbstractPage page = this.pageManager.getAbstractPage(pageId.longValue());
            if (page == null) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
            Space space = page.getSpace();
            if (space == null) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
            if (!this.canUnlinkDocument(page, Arrays.asList(objectId), loggedInUser)) {
                return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
            }
            pages.add(page);
        }
        this.documentLinkService.delete(pages, objectId);
        final DocumentLinks links = new DocumentLinks();
        this.documentLinkService.streamEntityByObjectId(Arrays.asList(objectId), new DocumentLinkStreamCallback(){

            @Override
            public void valueRead(DocumentLinkEntity entity) {
                String username = DocumentLinkResource.this.userKey2username(entity.getAuthorKey());
                DocumentLink link = new DocumentLink(entity.getSpaceId(), entity.getPageId(), entity.getObjectId(), entity.getAuthorKey(), username, entity.getCreated());
                AbstractPage page = DocumentLinkResource.this.pageManager.getAbstractPage(entity.getPageId());
                link.setEnableUnlink(DocumentLinkResource.this.featurePermissionResourceHelper.canUnlinkDocument(page, link, loggedInUser));
                links.addLink(link);
            }
        });
        return Response.ok((Object)links).build();
    }

    private boolean canUnlinkDocument(AbstractPage page, List<String> objectIds, ConfluenceUser user) {
        DocumentLinkEntity[] unlinkDocuments;
        for (DocumentLinkEntity entity : unlinkDocuments = this.documentLinkService.find(page, objectIds)) {
            String username = this.userKey2username(entity.getAuthorKey());
            DocumentLink unlinkDocument = new DocumentLink(entity.getSpaceId(), entity.getPageId(), entity.getObjectId(), entity.getAuthorKey(), username, entity.getCreated());
            if (this.featurePermissionResourceHelper.canUnlinkDocument(page, unlinkDocument, user)) continue;
            return false;
        }
        return true;
    }

    private String getServerId() {
        String serverId = null;
        try {
            serverId = this.sidManager.getSid();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return serverId;
    }

    private String userKey2username(String userKey) {
        ConfluenceUser author;
        if (StringUtils.isNotEmpty((CharSequence)userKey) && (author = this.userAccessor.getUserByName(userKey)) != null) {
            return author.getName();
        }
        return null;
    }

    @XmlRootElement(name="documentLink")
    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class DocumentLinkRequest {
        @XmlAttribute(name="pageId")
        private List<Long> pageId = new ArrayList<Long>();
        @XmlAttribute(name="objectId")
        private List<String> objectId = new ArrayList<String>();

        public DocumentLinkRequest() {
        }

        public DocumentLinkRequest(List<Long> pageId, List<String> objectId) {
            this.pageId = pageId;
            this.objectId = objectId;
        }

        public List<Long> getPageId() {
            return this.pageId;
        }

        public void setPageId(List<Long> pageId) {
            this.pageId = pageId;
        }

        public List<String> getObjectId() {
            return this.objectId;
        }

        public void setObjectId(List<String> objectId) {
            this.objectId = objectId;
        }
    }
}

