/*
 * Decompiled with CFR 0.152.
 */
package jp.ricksoft.plugins.alfresco.profile;

import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.xwork.RequireSecurityToken;
import jp.ricksoft.plugins.alfresco.ao.entity.CredentialEntity;
import jp.ricksoft.plugins.alfresco.ao.entity.CredentialSecret;
import jp.ricksoft.plugins.alfresco.ao.service.CredentialSecretService;
import jp.ricksoft.plugins.alfresco.ao.service.CredentialService;
import jp.ricksoft.plugins.alfresco.profile.UserProfileAction;
import org.apache.commons.lang3.StringUtils;

public class UserProfileEditAction
extends UserProfileAction {
    private static final long serialVersionUID = 3168028463546273384L;

    @RequireSecurityToken(value=true)
    public String doSave() {
        if (this.isInvalidLicense()) {
            return this.getInvalidLicenseRedirect();
        }
        this.doValidate();
        if (this.hasErrors()) {
            return "error";
        }
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        CredentialService credentialService = this.credentialService;
        CredentialSecretService credentialSecretService = this.credentialSecretService;
        CredentialEntity credentialEntity = credentialService.find();
        if (credentialEntity == null) {
            this.addActionError(this.getText("alfresco.for.confluence.user.credential.update.error.empty"));
            return "error";
        }
        CredentialSecret credentialSecret = credentialSecretService.find(user);
        if (credentialSecret == null) {
            credentialSecretService.save(credentialEntity, user, this.credentialUsername, this.credentialPassword);
        } else {
            credentialSecretService.update(credentialEntity, credentialSecret.getID(), user, this.credentialUsername, this.credentialPassword);
        }
        return "success";
    }

    void doValidate() {
        if (StringUtils.isBlank((CharSequence)this.credentialUsername)) {
            this.addFieldError("credentialUsername", this.getText("alfresco.for.confluence.user.credential.username.error.empty"));
        }
        if (StringUtils.isBlank((CharSequence)this.credentialPassword)) {
            this.addFieldError("credentialPassword", this.getText("alfresco.for.confluence.user.credential.password.error.empty"));
        }
    }
}

