/*
 * Decompiled with CFR 0.152.
 */
package jp.ricksoft.plugins.alfresco.auth;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class AuthUtils {
    public static String encodeBase64(String input) {
        try {
            return Base64.encodeBase64String((byte[])input.getBytes("UTF-8")).trim();
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Platform does not support UTF-8.", e);
        }
    }

    public static String encodeMD4(String input) {
        try {
            MessageDigest digester = MessageDigest.getInstance("MD4");
            byte[] hash = digester.digest(input.getBytes("UnicodeLittleUnmarked"));
            return new String(Hex.encodeHex((byte[])hash));
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Platform does not support MD4.", e);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Platform does not support UnicodeLittleUnmarked.", e);
        }
    }

    public static String generateCreated() {
        return new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'").format(new Date());
    }

    public static String generateNonce() {
        try {
            SecureRandom random = SecureRandom.getInstance("SHA1PRNG");
            byte[] bytes = new byte[16];
            random.nextBytes(bytes);
            return Base64.encodeBase64String((byte[])bytes);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Platform does not support SHA1PRNG.", e);
        }
    }

    public static String generatePasswordDigest(String nonce, String created, String password) {
        try {
            StringBuffer buffer = new StringBuffer();
            buffer.append(nonce);
            buffer.append(created);
            buffer.append(password);
            MessageDigest messageDigest = MessageDigest.getInstance("SHA1");
            byte[] hash = messageDigest.digest(buffer.toString().getBytes("UTF-8"));
            return Base64.encodeBase64String((byte[])hash);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Platform does not support sha1.", e);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Platform does not support UTF-8.", e);
        }
    }

    static {
        try {
            MessageDigest.getInstance("MD4");
        }
        catch (NoSuchAlgorithmException e) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }
}

