/*
 * Decompiled with CFR 0.152.
 */
package jp.ricksoft.plugins.alfresco.admin;

import com.atlassian.confluence.user.ConfluenceUser;
import jp.ricksoft.plugins.alfresco.admin.AlfrescoBaseAction;
import jp.ricksoft.plugins.alfresco.auth.InvalidTokenException;
import org.apache.log4j.Logger;

public class FeaturePermissionAction
extends AlfrescoBaseAction {
    private static final Logger LOGGER = Logger.getLogger(FeaturePermissionAction.class);

    public String execute() {
        if (this.isInvalidLicense()) {
            return this.getInvalidLicenseRedirect();
        }
        try {
            ConfluenceUser user = this.getAuthenticatedUser();
            if (this.isOverMaximumLoginAttemptAllowed()) {
                LOGGER.warn((Object)"Cmis Maximum Login Attempt Allowed Over Error.");
                this.addActionError(this.getText("alfresco.for.jira.admin.error.overMaximumLoginAttemptAllowed"));
                return "error";
            }
        }
        catch (InvalidTokenException e) {
            LOGGER.warn((Object)"Cmis Invalid Token Error.", (Throwable)e);
            this.addActionError(this.getText("alfresco.for.jira.admin.error.token"));
        }
        catch (Exception e) {
            LOGGER.warn((Object)"Cmis Invalid Token Error.", (Throwable)e);
            this.addActionError(this.getText("alfresco.for.jira.admin.error.unexpected"));
        }
        return "success";
    }
}

